#include "mbed.h"

/*****************************************************************************
generar un programa que controle por el puerto serial el grado de 4 servo motores
por medio de la comunicacion serial donde el comando sea 

|            |            |             |
|   INITCMD  |   N_motor  |   N_grados  |
|     0xff   | 0x01- 0x04 | 0x00 - 0xb4 |

para enviar los comandos usar el programa Coolterm
*****************************************************************************/


Serial command(USBTX, USBRX);
PwmOut myservo1(PB_3);
PwmOut myservo2(PB_4);
PwmOut myservo3(PA_9);
PwmOut myservo4(PB_10);

/*INGRESE L A CONFIGURACION DE LOS MOTORES*/

#define INITCMD 0xFF
#define DEGREES_MAX 180
// definición de las variables globales 

uint8_t N_motor;    // almacena el número de motor
uint8_t N_grados;    // almacena los grados que se mueve el motor


// definición de las funciones
void setup_uart();
void setup_servo();

void mover_servo(uint8_t motor, uint8_t gradss);
uint32_t degrees2usec(uint8_t grados){

void leer_datos();

    
    
int main() {

    setup_uart();
    setup_servo();
    //command.printf("inicio de programa");
    while(1){    
        leer_datos();
        mover_servo(N_motor, N_grados);
    }    
}



void setup_uart(){
    command.baud(115200);
}

void setup_servo(){
    myservo1.period_ms(20);
    myservo1.pulsewidth_us(1000);
}

void leer_datos(){
    while(command.getc()!= INITCMD);
    N_motor=command.getc();
    N_grados=command.getc();
    
}




void mover_servo(uint8_t motor, uint8_t grados){

        uint32_t dpulse=0;
        
/* complementar el código necesario
   tip: deben pasar  grados a microsegundo */
//fghgfhfgdhfdghfghg

     dpulse=degrees2usec(grados);
     myservo1.pulsewidth_us(dpulse);

}

uint32_t degrees2usec(uint8_t grados){
// Retorno el valor en usegundos, donde
//     y − y1 = m(x − x1 )
    if(grados <= DEGREES_MAX)
        return int(500+grados*2400/180);// u6
    return 500;
    
}