/* mbed library for using USART DMA in STM32F401RE.
 * Copyright (c) 2015 Match
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"

uint8_t data[] = "Hello.\n"
                 "How are you?\n"
                 "abcdefghijklmnopqrstuvwxyz\n"
                 "ABCDEFGHIJKLMNOPQRSTUVWXYZ\n"
                 "See you.\n\n";

DMA_HandleTypeDef usartTxDma;
USART_HandleTypeDef usart;

void Init();

int main() {
    Init();
    
    HAL_USART_Transmit_DMA(&usart, data, sizeof(data));
    
    while(1) {
        
    }
}

void Init() {
    // DMA
    // USART2 TX is DMA1 channel 4 stream 6. Look at table 28 in STM32F401 reference manual.
    __DMA1_CLK_ENABLE();
    usartTxDma.Instance = DMA1_Stream6;
    usartTxDma.Init.Channel = DMA_CHANNEL_4;
    usartTxDma.Init.Direction = DMA_MEMORY_TO_PERIPH;
    usartTxDma.Init.PeriphInc = DMA_PINC_DISABLE;
    usartTxDma.Init.MemInc = DMA_MINC_ENABLE;
    usartTxDma.Init.PeriphDataAlignment = DMA_PDATAALIGN_BYTE;  // 8 bit
    usartTxDma.Init.MemDataAlignment = DMA_PDATAALIGN_BYTE;     // 8 bit
    usartTxDma.Init.Mode = DMA_NORMAL;
    usartTxDma.Init.Priority = DMA_PRIORITY_VERY_HIGH;
    usartTxDma.Init.FIFOMode = DMA_FIFOMODE_DISABLE;
    HAL_DMA_Init(&usartTxDma);
    
    // USART pin
    __GPIOA_CLK_ENABLE();
    GPIO_InitTypeDef usartTxd;
    usartTxd.Pin = GPIO_PIN_2;
    usartTxd.Mode = GPIO_MODE_AF_PP;
    usartTxd.Pull = GPIO_NOPULL;
    usartTxd.Speed = GPIO_SPEED_HIGH;
    usartTxd.Alternate = GPIO_AF7_USART2;
    HAL_GPIO_Init(GPIOA, &usartTxd);
    
    // USART
    __USART2_CLK_ENABLE();
    usart.Init.BaudRate = 921600;
    usart.Init.WordLength = USART_WORDLENGTH_8B;
    usart.Init.StopBits = USART_STOPBITS_1;
    usart.Init.Parity = USART_PARITY_NONE;
    usart.Init.Mode = USART_MODE_TX;    // transmit only mode
    usart.Instance = USART2;
    usart.hdmatx = &usartTxDma;
    HAL_USART_Init(&usart);
}
