/* sample for dimming led with pwm.
 * Copyright (c) 2015 Match
 */

#include "mbed.h"

// F401, F411 can use LED1.
// Other platform, use pwm pin and connect led.
PwmOut myled(LED1);

int main() {
    int duty = 0;   // unit:%
    myled.period_ms(1);     // pwm frequency set 1kHz.
    
    while(1) {
        // until 100%, increase by 5% in 50ms intervals
        for (; duty <= 100; duty += 5) {
            myled = duty / 100.0;
            wait_ms(50);
        }
        // until 0%, decrease by 5% in 50ms intervals
        for (; duty >= 0; duty -= 5) {
            myled = duty / 100.0;
            wait_ms(50);
        }
    }
}