/* mbed library for LM61
 * 
 * Copyright (C) 2015 Match
 *
 * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "LM61.h"

LM61::LM61(PinName lm61, float vcc) : _lm61(lm61){
    _vcc = vcc;
}

float LM61::GetTemp() {
    return (_lm61.read()*_vcc - 0.6f) * 100;
}