/* mbed library for LM61
 * 
 * Copyright (C) 2015 Match
 *
 * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef LM61_H_2014_12_31
#define LM61_H_2014_12_31

#include "mbed.h"

/** Get temperature from LM61 class
 *
 * Example:
 * @code
 * #include "LM61.h"
 * #include "mbed.h"
 * 
 * LM61 lm61(dp4, 3.0f);
 * Serial pc(USBTX, USBRX);
 * 
 * int main() {
 *     float temp;
 *     
 *     while(1) {
 *         temp = lm61.GetTemp();
 *         pc.printf("Temperature : %5.1fdeg\n", temp);
 *         wait(1);
 *     }
 * }
 * @endcode
 */
class LM61 {
public:
    
    /** A constructor of LM61 class
     * @param lm61 pin connected to vout of LM61
     * @param vcc Vcc voltage
     */
    LM61(PinName lm61, float vcc=3.3f);
    
    /** Get temperature from LM61
     * @return temperature from LM61 in degree
     */
    float GetTemp();
    
private:
    AnalogIn _lm61;
    float _vcc;
};


#endif  // LM61_H_2014_12_31