#include <mbed.h>

#include "ReceiverIR.h"
#include "TextLCD.h"

ReceiverIR ir_rx(p17);
TextLCD lcd(p24, p26, p27, p28, p29, p30);
BusOut led(LED4, LED3, LED2, LED1);
Ticker ledTicker;

int receive(RemoteIR::Format *format, uint8_t *buf, int bufsiz, int timeout = 100) {
    int cnt = 0;
    while (ir_rx.getState() != ReceiverIR::Received) {
        cnt++;
        if (timeout < cnt) {
            return -1;
        }
    }
    return ir_rx.getData(format, buf, bufsiz * 8);
}

void display_status(char *status, int bitlength) {
    lcd.locate(8, 0);
    lcd.printf("%-5.5s:%02d", status, bitlength);
}

void display_format(RemoteIR::Format format) {
    lcd.locate(0, 0);
    switch (format) {
        case RemoteIR::UNKNOWN:
            lcd.printf("????????");
            break;
        case RemoteIR::NEC:
            lcd.printf("NEC     ");
            break;
        case RemoteIR::NEC_REPEAT:
            lcd.printf("NEC  (R)");
            break;
        case RemoteIR::AEHA:
            lcd.printf("AEHA    ");
            break;
        case RemoteIR::AEHA_REPEAT:
            lcd.printf("AEHA (R)");
            break;
        case RemoteIR::SONY:
            lcd.printf("SONY    ");
            break;
    }
}

void display_data(uint8_t *buf, int bitlength) {
    lcd.locate(0, 1);
    const int n = bitlength / 8 + (((bitlength % 8) != 0) ? 1 : 0);
    for (int i = 0; i < n; i++) {
        lcd.printf("%02X", buf[i]);
    }
    for (int i = 0; i < 8 - n; i++) {
        lcd.printf("--");
    }
}

void ledfunc(void) {
    led = led + 1;
}

int main(void) {
    ledTicker.attach(&ledfunc, 0.5);

    led = 0;
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Press a button  ");
    lcd.locate(0, 1);
    lcd.printf("on a controller.");

    while (1) {
        uint8_t buf1[32];
        uint8_t buf2[32];
        int bitlength1;
        int bitlength2;
        RemoteIR::Format format;

        memset(buf1, 0x00, sizeof(buf1));
        memset(buf2, 0x00, sizeof(buf2));

        {
            bitlength1 = receive(&format, buf1, sizeof(buf1));
            if (bitlength1 < 0) {
                continue;
            }
            display_status("RECV", bitlength1);
            display_data(buf1, bitlength1);
            display_format(format);
        }

    }
}