#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"  //ADD Here!!
DigitalOut led1(LED1,"led1");
DigitalOut led2(LED2,"led2");
DigitalOut led3(LED3,"led3");
DigitalOut led4(LED4,"led4");
 
TextLCD lcd(p24, p26, p27, p28, p29, p30);
 
#if 1
/*
 * Use DHCP
 */
        EthernetNetIf ethif;
#else
/*
 * Use "static IP address" (Parameters:IP, Subnet mask, Gateway, DNS)
 */
        EthernetNetIf ethif(IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx));
#endif
    
    HTTPServer server;
    LocalFileSystem local("local");
    void LcdWrite(char *input,char *output);    //ADD Here!!
    RPCFunction rpcFunc(&LcdWrite, "LcdWrite"); //ADD Here!!
 
int main(void) {
 
    Base::add_rpc_class<DigitalOut>();
 
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Program init..  ");
 
    if (ethif.setup()) {
        error("Ethernet setup failed.");
        return 1;
    }
    IpAddr ethIp=ethif.getIp();
    
    lcd.locate(0,1);
    lcd.printf("%d.%d.%d.%d", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);
    led1=1;
    wait(1);
    server.addHandler<SimpleHandler>("/hello");
    server.addHandler<RPCHandler>("/rpc");
    FSHandler::mount("/local", "/");
    server.addHandler<FSHandler>("/");
    server.bind(80);
    while (1) {
        Net::poll();
    }
    return 0;
}
void LcdWrite(char *input , char *output)  //ADD Here!!
{
    lcd.locate(0,1);
    lcd.printf("%s",input);
}