#include "mbed.h"
#include "rtos.h"
#include "MotionSensor.h"
#include "FXAS21000.h"
#include "FXOS8700Q.h"

Serial pc(USBTX, USBRX);
I2C i2c(PTE25, PTE24);
I2C i2c_gyro(A4, A5);

FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);    // Configured for the FRDM-K64F with onboard sensors
FXOS8700QMagnetometer mag(i2c, FXOS8700CQ_SLAVE_ADDR1);
FXAS21000Gyroscpe gyro(i2c_gyro, FXAS21000_SLAVE_ADDR);

int main(void)
{
    motion_data_units_t acc_data, mag_data, gyro_data;
    
    acc.enable();
    mag.enable();
    gyro.enable();
    //printf("FXOS8700QAccelerometer Who Am I= %X\r\n", acc.whoAmI());
    //printf("FXOS8700QMagnetometer Who Am I= %X\r\n", acc.whoAmI());
    //printf("FXAS21000Gyroscope Who am I= %X\r\n", gyro.whoAmI());

    while (true) {
        // unit based results
        acc.getAxis(acc_data);
        mag.getAxis(mag_data);
        gyro.getAxis(gyro_data);
        /*
        printf("%1.4f,%1.4f,%1.4f,%4.1f,%4.1f,%4.1f,%1.4f,%1.4f,%1.4f\r\n", acc_data.x, acc_data.y, acc_data.z, mag_data.x, mag_data.y, mag_data.z,
        gyro_data.x, gyro_data.y, gyro_data.z);
        */
     
        printf("%1.4f,%1.4f,%1.4f\r\n", gyro_data.x, gyro_data.y, gyro_data.z);
        wait(0.5f);
    }
}