/**
@file music.cpp

@brief Member functions implementations

*/

#include "music.h"

void speaker::tone(float frequency,float duration)
{
    if (frequency > 0) {
        float dt = 1.0f/(frequency*n) - (1.34e-6 + 1e-6);
        note_timer.start();
        while(note_timer.read() < duration) {
            for (int i = 0; i < n ; i++) {
                *Speaker = y[i];
                wait(dt);
            }
        }
        *Speaker = 0.0f;
        note_timer.stop();
        note_timer.reset();
    } else {
        wait(duration);
    }
    wait(duration);
}