/**
@file main.cpp

@brief Member functions implementations

*/

#include "main.h"

int main()
{
    init_K64F();
    init_N5110();
    init_obj();
    calibrate_joystick();  // get centred values of joystick
    refresh_rate = 10.0f;
    g_dt = 1.0f/refresh_rate;
    update_flag.attach(&update_flag_func,g_dt);  // read joystick n times per second
    
    //used to initialise the highscore files
    /*fp = fopen("/sd/firstname.txt", "w");
    fprintf(fp, "AAA");
    fclose(fp);
    fp = fopen("/sd/secondname.txt", "w");
    fprintf(fp, "AAA");
    fclose(fp);
    fp = fopen("/sd/thirdname.txt", "w");
    fprintf(fp, "AAA");
    fclose(fp);
    fp = fopen("/sd/fourthname.txt", "w");
    fprintf(fp, "AAA");
    fclose(fp);
    fp = fopen("/sd/fifthname.txt", "w");
    fprintf(fp, "AAA");
    fclose(fp);
    fp = fopen("/sd/firstscore.txt", "w");
    fprintf(fp, "%d",selector);
    fclose(fp);
    fp = fopen("/sd/secondscore.txt", "w");
    fprintf(fp, "%d",selector);
    fclose(fp);
    fp = fopen("/sd/thirdscore.txt", "w");
    fprintf(fp, "%d",selector);
    fclose(fp);
    fp = fopen("/sd/fourthscore.txt", "w");
    fprintf(fp, "%d",selector);
    fclose(fp);
    fp = fopen("/sd/fifthscore.txt", "w");
    fprintf(fp, "%d",selector);
    fclose(fp);*/
    
    menu_viewed=0;
    js_button_previous=0;
    b_button_previous=0;
    up_flag=0;
    menu();
}

// read default positions of the joystick to calibrate later readings
void calibrate_joystick()
{
    js_button.mode(PullDown);
    b_button.mode(PullDown);
    // must not move during calibration
    joystick.x0 = js_pot_x;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = js_pot_y;
}

void update_flag_func()
{
    up_flag=1;
}

void update_joystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = js_pot_x - joystick.x0;
    joystick.y = js_pot_y - joystick.y0;
    // read button selector
    joystick.button = js_button_check();
    joystick.bbutton = b_button_check();

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the selectord direction
    if(fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if(joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if(joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if(joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if(joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else if(joystick.y < DIRECTION_TOLERANCE && joystick.x > DIRECTION_TOLERANCE) {
        joystick.direction = UPRIGHT;
    } else if(joystick.y < DIRECTION_TOLERANCE && joystick.x < DIRECTION_TOLERANCE) {
        joystick.direction = UPLEFT;
    } else if(joystick.y > DIRECTION_TOLERANCE && joystick.x > DIRECTION_TOLERANCE) {
        joystick.direction = DOWNRIGHT;
    } else if(joystick.y > DIRECTION_TOLERANCE && joystick.x < DIRECTION_TOLERANCE) {
        joystick.direction = DOWNLEFT;
    } else {
        joystick.direction = UNKNOWN;
    }
}

bool js_button_check()
{
    if((js_button_previous==1) && (js_button==1)) {
        return 0;
    } else if((js_button_previous==0) && (js_button==1)) {
        js_button_previous=1;
        return 1;
    } else {
        js_button_previous=0;
        return 0;
    }
}

bool b_button_check()
{
    if((b_button_previous==1) && (b_button==1)) {
        return 0;
    } else if((b_button_previous==0) && (b_button==1)) {
        b_button_previous=1;
        return 1;
    } else {
        b_button_previous=0;
        return 0;
    }
}

void init_K64F()
{
    // on-board LEDs are active-low, so set pin high to turn them off.
    r_led=1;
    g_led=0;
    b_led=1;

    // since the on-board switches have external pull-ups, we should disable the internal pull-down
    // resistors that are enabled by default using InterruptIn
    sw2.mode(PullNone);
    sw3.mode(PullNone);

}

void init_N5110()
{
    lcd.init();
    lcd.normalMode();
    lcd.setBrightness(0.5);
}

void init_obj()
{
    player_still_obj.fill(player_still);
    player_moving1_obj.fill(player_moving1);
    player_moving2_obj.fill(player_moving2);
    player_jumping_obj.fill(player_jumping);
    pointer_obj.fill(pointer);
    spike_small_obj1.fill(spike_small);
    spike_small_obj2.fill(spike_small);
    spike_small_obj3.fill(spike_small);
    spike_large_obj1.fill(spike_large);
    spike_large_obj2.fill(spike_large);
}

void menu()
{
    while(!joystick.button && !joystick.bbutton && !menu_viewed) {
        if(up_flag) {
            up_flag=0;
            update_joystick();
        }
        lcd.clear();
        lcd.printString("Cave Runner",10,0);
        player.draw(34,31);
        lcd.printString("Press A or B",6,5);
        selector=0;
        option=1;
        lcd.refresh();
        sleep();
    }
    if(joystick.button && !menu_viewed) {
        buzzer.tone(NOTE_C4,SEMIQUAVER);
    } else if(joystick.bbutton && !menu_viewed) {
        buzzer.tone(NOTE_D3,SEMIQUAVER);
    }
    update_joystick();
    lcd.clear();
    menu_viewed=1;
    while(!joystick.button) {
        if(up_flag) {
            up_flag=0;
            update_joystick();
        }
        //read highscores
        fp = fopen("/sd/firstscore.txt", "r");
        fscanf(fp, "%d",&highscore1);
        fclose(fp);
        fp = fopen("/sd/secondscore.txt", "r");
        fscanf(fp, "%d",&highscore2);
        fclose(fp);
        fp = fopen("/sd/thirdscore.txt", "r");
        fscanf(fp, "%d",&highscore3);
        fclose(fp);
        fp = fopen("/sd/fourthscore.txt", "r");
        fscanf(fp, "%d",&highscore4);
        fclose(fp);
        fp = fopen("/sd/fifthscore.txt", "r");
        fscanf(fp, "%d",&highscore5);
        fclose(fp);
        //read highscore names
        fp = fopen("/sd/firstname.txt", "r");
        fscanf(fp, "%c",&name1[0]);
        fscanf(fp, "%c",&name1[1]);
        fscanf(fp, "%c",&name1[2]);
        fscanf(fp, "%c",&name1[3]);
        fclose(fp);
        fp = fopen("/sd/secondname.txt", "r");
        fscanf(fp, "%c",&name2[0]);
        fscanf(fp, "%c",&name2[1]);
        fscanf(fp, "%c",&name2[2]);
        fscanf(fp, "%c",&name2[3]);
        fclose(fp);
        fp = fopen("/sd/thirdname.txt", "r");
        fscanf(fp, "%c",&name3[0]);
        fscanf(fp, "%c",&name3[1]);
        fscanf(fp, "%c",&name3[2]);
        fscanf(fp, "%c",&name3[3]);
        fclose(fp);
        fp = fopen("/sd/fourthname.txt", "r");
        fscanf(fp, "%c",&name4[0]);
        fscanf(fp, "%c",&name4[1]);
        fscanf(fp, "%c",&name4[2]);
        fscanf(fp, "%c",&name4[3]);
        fclose(fp);
        fp = fopen("/sd/fifthname.txt", "r");
        fscanf(fp, "%c",&name5[0]);
        fscanf(fp, "%c",&name5[1]);
        fscanf(fp, "%c",&name5[2]);
        fscanf(fp, "%c",&name5[3]);
        fclose(fp);
        switch(selector) {
            case 0:
                lcd.clear();
                lcd.printString("Cave Runner",10,0);
                lcd.printString("Start Game",16,2);
                lcd.printString("Highscores",16,3);
                lcd.printString("Rules",16,4);
                lcd.printString("Credits",16,5);
                pointer_obj.draw(10,21);
                option=1;
                lcd.refresh();
                if(joystick.direction==DOWN) {
                    selector=1;
                    buzzer.tone(NOTE_A3,SEMIQUAVER);
                    break;
                } else {
                    selector=0;
                    wait(0.1);
                    break;
                }
            case 1:
                lcd.clear();
                lcd.printString("Cave Runner",10,0);
                lcd.printString("Start Game",16,2);
                lcd.printString("Highscores",16,3);
                lcd.printString("Rules",16,4);
                lcd.printString("Credits",16,5);
                pointer_obj.draw(10,29);
                option=2;
                lcd.refresh();
                if(joystick.direction==UP) {
                    selector=0;
                    buzzer.tone(NOTE_A3,SEMIQUAVER);
                    break;
                } else if(joystick.direction==DOWN) {
                    selector=2;
                    buzzer.tone(NOTE_A3,SEMIQUAVER);
                    break;
                } else {
                    selector=1;
                    wait(0.1);
                    break;
                }
            case 2:
                lcd.clear();
                lcd.printString("Cave Runner",10,0);
                lcd.printString("Start Game",16,2);
                lcd.printString("Highscores",16,3);
                lcd.printString("Rules",16,4);
                lcd.printString("Credits",16,5);
                pointer_obj.draw(10,37);
                option=3;
                lcd.refresh();
                if(joystick.direction==UP) {
                    selector=1;
                    buzzer.tone(NOTE_A3,SEMIQUAVER);
                    break;
                } else if(joystick.direction==DOWN) {
                    selector=3;
                    buzzer.tone(NOTE_A3,SEMIQUAVER);
                    break;
                } else {
                    selector=2;
                    wait(0.1);
                    break;
                }
            case 3:
                lcd.clear();
                lcd.printString("Cave Runner",10,0);
                lcd.printString("Start Game",16,2);
                lcd.printString("Highscores",16,3);
                lcd.printString("Rules",16,4);
                lcd.printString("Credits",16,5);
                pointer_obj.draw(10,45);
                option=4;
                lcd.refresh();
                if(joystick.direction==UP) {
                    selector=2;
                    buzzer.tone(NOTE_A3,SEMIQUAVER);
                    break;
                } else {
                    selector=3;
                    wait(0.1);
                    break;
                }
        }
        sleep();
    }
    menu_select();
}

void menu_select()
{
    buzzer.tone(NOTE_C4,SEMIQUAVER);
    update_joystick();
    if(option==1) {
        start_game();
    } else if(option==2) {
        highscores();
    } else if(option==3) {
        rules();
    } else if(option==4) {
        credits();
    }
}

void start_game()
{
    wait(g_dt);
    update_joystick();
    lcd.clear();
    screen.init();
    init_game();
    while(1) {
        if(up_flag) {
            up_flag=0;
            update_joystick();
            check_collisions();
            update_physics_engine();
            redraw();
        }
        score_counter++;
        if(joystick.direction==CENTRE) {
            vel.x=0.0;
            vel.y=0.0;
        } else if(joystick.direction==RIGHT) {
            vel.x=4.0;
            vel.y=0.0;
        } else if(joystick.direction==LEFT) {
            vel.x=-4.0;
            vel.y=0.0;
        } else if((joystick.direction==UP) && (jump_counter<3)) {
            jump_counter++;
            vel.x=0.0;
            vel.y=-8.0;
        } else if((joystick.direction==UPRIGHT) && (jump_counter<3)) {
            jump_counter++;
            vel.x=4.0;
            vel.y=-8.0;
        } else if((joystick.direction==UPLEFT) && (jump_counter<3)) {
            jump_counter++;
            vel.x=-4.0;
            vel.y=-8.0;
        }
        //check is there will be a spike spawn
        if(!spike1_there) {
            if((rand()%30)==3) {
                spike1_there=1;
                spike_x1=79;
            }
        }
        if((!spike2_there) && (score_counter>100)) {
            if((rand()%30)==9) {
                spike2_there=1;
                spike_x2=79;
            }
        }
        if((!spike3_there) && (score_counter>200)) {
            if((rand()%30)==18) {
                spike3_there=1;
                spike_x3=79;
            }
        }
        if((!spike4_there) && (score_counter>500)) {
            if((rand()%50)==24) {
                spike4_there=1;
                spike_x4=78;
            }
        }
        if((!spike5_there) && (score_counter>1000)) {
            if((rand()%50)==42) {
                spike5_there=1;
                spike_x5=78;
            }
        }
        //check for spike actions if they are on screen
        if(spike1_there) {
            if(spike_small_obj1.check_collision(spike_x1,41)) {
                health--;
                spike1_there=0;
                buzzer.tone(NOTE_CS1,SEMIQUAVER);
            }
            if(spike_x1<0) {
                spike1_there=0;
            }
            spike_x1--;
        }
        if(spike2_there) {
            if(spike_small_obj2.check_collision(spike_x2,41)) {
                health--;
                spike2_there=0;
                buzzer.tone(NOTE_CS1,SEMIQUAVER);
            }
            if(spike_x2<0) {
                spike2_there=0;
            }
            spike_x2--;
        }
        if(spike3_there) {
            if(spike_small_obj3.check_collision(spike_x3,41)) {
                health--;
                spike3_there=0;
                buzzer.tone(NOTE_CS1,SEMIQUAVER);
            }
            if(spike_x3<0) {
                spike3_there=0;
            }
            spike_x3--;
        }
        if(spike4_there) {
            if(spike_large_obj1.check_collision(spike_x4,41)) {
                health--;
                spike4_there=0;
                buzzer.tone(NOTE_CS1,SEMIQUAVER);
            }
            if(spike_x4<0) {
                spike4_there=0;
            }
            spike_x4--;
        }
        if(spike5_there) {
            if(spike_large_obj2.check_collision(spike_x5,41)) {
                health--;
                spike5_there=0;
                buzzer.tone(NOTE_CS1,SEMIQUAVER);
            }
            if(spike_x5<0) {
                spike5_there=0;
            }
            spike_x5--;
        }
        if(dead) {
            //bwom bwom bwom to be added
            death();
        }
        sleep();
    }
}

void init_game()
{
    health=5;
    dead=0;
    jump_counter=0;
    score_counter=0;
    spike1_there=0;
    spike2_there=0;
    spike3_there=0;
    spike4_there=0;
    spike5_there=0;
    spike1_counter=0;
    spike2_counter=0;
    spike3_counter=0;
    spike4_counter=0;
    spike5_counter=0;
    bat1.counter=0;
    bat2.counter=0;
    bat3.counter=0;
    bat4.counter=0;
    bat5.counter=0;
    bat1.state=0;
    bat2.state=0;
    bat3.state=0;
    bat4.state=0;
    bat5.state=0;
    bat1.next=0;
    bat2.next=0;
    bat3.next=0;
    bat4.next=0;
    bat5.next=0;
    background.counter=0;
    for(int i=43; i<48; i++) {
        for(int j=0; j<84; j++) {
            screen.set_pixel(j,i,GAME);
        }
    }
    background.init();
    background.fill(screen.layers);
    init_player();
    background.draw_screen(BG);
    draw_health();
    screen.draw();
    lcd.printString("READY",28,2);
    wait(1.0);
    lcd.printString("GO!",35,3);
    wait(1.0);
    lcd.refresh();
}

void init_player()
{
    pos.x = 0;
    pos.y = 42;
    player.draw_screen(pos.x,pos.y,GAME);
    vel.x = 0.0;
    vel.y = 0.0;
    acc.x = 0.0;
    acc.y = 0.0;
}

void draw_health()
{
    if(health==5) {
        bat1.draw_screen(0,6,HEALTH);
        bat2.draw_screen(13,6,HEALTH);
        bat3.draw_screen(26,6,HEALTH);
        bat4.draw_screen(39,6,HEALTH);
        bat5.draw_screen(52,6,HEALTH);
    } else if (health==4) {
        bat1.draw_screen(0,6,HEALTH);
        bat2.draw_screen(13,6,HEALTH);
        bat3.draw_screen(26,6,HEALTH);
        bat4.draw_screen(39,6,HEALTH);
    } else if (health==3) {
        bat1.draw_screen(0,6,HEALTH);
        bat2.draw_screen(13,6,HEALTH);
        bat3.draw_screen(26,6,HEALTH);
    } else if (health==2) {
        bat1.draw_screen(0,6,HEALTH);
        bat2.draw_screen(13,6,HEALTH);
    } else if (health==1) {
        bat1.draw_screen(0,6,HEALTH);
    } else if (health==0) {
        dead=1;
    }
}

void check_collisions()
{
    //groud collision
    for(int i=0; i<13; i++) {
        if(screen.get_pixel((pos.x + i),(pos.y + 1),GAME)==0) {
            acc.y = 4.0;
            jumping = true;
        } else {
            acc.y = 0.0;
            jump_counter=0;
            jumping = false;
            break;
        }
    }
    //ceilling pixel collision
    for(int i=0; i<13; i++) {
        if(screen.get_pixel((pos.x + i),(pos.y - 15),GAME)==0) {
            acc.y = acc.y;
        } else {
            vel.y = - vel.y;
            acc.y = 4.0;
            break;
        }
    }
    //ceilling screen collision
    if((pos.y - 14) == 0) {
        vel.y = - vel.y;
        acc.y = 4.0;
    }
    //right pixel collision
    for(int j=0; j<15; j++) {
        if((screen.get_pixel((pos.x + 13),(pos.y - j),GAME)==1) && (pos.x + 13 < 84)) {
            vel.x = -vel.x;
            break;
        }
    }
    //left pixel collision
    for(int j=0; j<15; j++) {
        if((screen.get_pixel((pos.x - 1),(pos.y - j),GAME)==1) && (pos.x - 1 > 0)) {
            vel.x = -vel.x;
            break;
        }
    }
}

void update_physics_engine()
{
    // from Newton's Laws

    // calc new velocity (assume 'unit' time)
    vel.x = vel.x + acc.x; // * g_gt;
    vel.y = vel.y + acc.y; // * g_gt;

    // calc new position (assume 'unit' time)
    pos.x = pos.x + vel.x;// * g_gt;
    pos.y = pos.y + vel.y;// * g_dt;
    
    //stops the character from falling off the side of the screen
    if(pos.x<0) {
        pos.x=0;
    }
    if(pos.x>71) {
        pos.x=71;
    }
    //stops the character from falling through the floor
    if((pos.y>42) && ((screen.get_pixel(pos.x+3,pos.y-10,GAME)) || (screen.get_pixel(pos.x+9,pos.y-6,GAME)))) {
        pos.y=42;
    }
    //stops the character from falling through platforms
    if((screen.get_pixel(pos.x,pos.y+1,GAME)) && !(screen.get_pixel(pos.x,pos.y+2,GAME))) {
        pos.y=pos.y-3;
    }
    
    // should really multiply the above by the time-step,
    // but since the pixel can only be a integer value,
    // it makes the motion a little 'jumpy'.

}

void redraw()
{
    lcd.clear();
    screen.clear();
    if(jumping) {
        player_jumping_obj.draw_screen(pos.x,pos.y,GAME);
    } else {
        player.draw_screen(pos.x,pos.y,GAME);
    }
    if(spike1_there) {
        spike_small_obj1.draw_screen(spike_x1,42,GAME);
    }
    if(spike2_there) {
        spike_small_obj2.draw_screen(spike_x2,42,GAME);
    }
    if(spike3_there) {
        spike_small_obj3.draw_screen(spike_x3,42,GAME);
    }
    if(spike4_there) {
        spike_large_obj1.draw_screen(spike_x4,42,GAME);
    }
    if(spike5_there) {
        spike_large_obj2.draw_screen(spike_x5,42,GAME);
    }
    for(int i=43; i<48; i++) {
        for(int j=0; j<84; j++) {
            screen.set_pixel(j,i,GAME);
        }
    }
    background.draw_screen(BG);
    draw_health();
    screen.draw();
    lcd.refresh();
    
}

void death()
{
    wait(g_dt);
    lcd.clear();
    while(!joystick.bbutton) {
        if(up_flag) {
            up_flag=0;
            update_joystick();
        }
        lcd.printString("Better Luck",10,1);
        lcd.printString("Next Time",15,2);
        lcd.printString("Your Score",13,4);
        sprintf(score,"%d",score_counter);
        lcd.printString(score,32,5);
        sleep();
    }
    buzzer.tone(NOTE_D3,SEMIQUAVER);
    new_highscore();
    menu();
}

void highscores()
{
    wait(g_dt);
    lcd.clear();
    while(!joystick.bbutton) {
        if(up_flag) {
            up_flag=0;
            update_joystick();
        }
        lcd.printString("Highscores",12,0);
        sprintf(score1,"%d",highscore1);
        lcd.printString(score1,42,1);
        lcd.printString(name1,20,1);
        sprintf(score2,"%d",highscore2);
        lcd.printString(score2,42,2);
        lcd.printString(name2,20,2);
        sprintf(score3,"%d",highscore3);
        lcd.printString(score3,42,3);
        lcd.printString(name3,20,3);
        sprintf(score4,"%d",highscore4);
        lcd.printString(score4,42,4);
        lcd.printString(name4,20,4);
        sprintf(score5,"%d",highscore5);
        lcd.printString(score5,42,5);
        lcd.printString(name5,20,5);
        sleep();
    }
    buzzer.tone(NOTE_D3,SEMIQUAVER);
    menu();
}

void new_highscore()
{
    if(score_counter>=highscore1) {
        highscore5=highscore4;
        highscore4=highscore3;
        highscore3=highscore2;
        highscore2=highscore1;
        highscore1=score_counter;
        lcd.clear();
        lcd.printString("New Highscore!",0,2);
        wait(2.0);
        register_name();
        fp = fopen("/sd/firstscore.txt", "w");
        fprintf(fp, "%d",highscore1);
        fclose(fp);
        fp = fopen("/sd/secondscore.txt", "w");
        fprintf(fp, "%d",highscore2);
        fclose(fp);
        fp = fopen("/sd/thirdscore.txt", "w");
        fprintf(fp, "%d",highscore3);
        fclose(fp);
        fp = fopen("/sd/fourthscore.txt", "w");
        fprintf(fp, "%d",highscore4);
        fclose(fp);
        fp = fopen("/sd/fifthscore.txt", "w");
        fprintf(fp, "%d",highscore5);
        fclose(fp);
        sprintf(name5,name4);
        sprintf(name4,name3);
        sprintf(name3,name2);
        sprintf(name2,name1);
        sprintf(name1,name);
        fp = fopen("/sd/firstname.txt", "w");
        fprintf(fp, name1);
        fclose(fp);
        fp = fopen("/sd/secondname.txt", "w");
        fprintf(fp, name2);
        fclose(fp);
        fp = fopen("/sd/thirdname.txt", "w");
        fprintf(fp, name3);
        fclose(fp);
        fp = fopen("/sd/fourthname.txt", "w");
        fprintf(fp, name4);
        fclose(fp);
        fp = fopen("/sd/fifthname.txt", "w");
        fprintf(fp, name5);
        fclose(fp);
    } else if(score_counter>=highscore2) {
        highscore5=highscore4;
        highscore4=highscore3;
        highscore3=highscore2;
        highscore2=score_counter;
        lcd.clear();
        lcd.printString("New Highscore!",0,2);
        wait(2.0);
        register_name();
        fp = fopen("/sd/secondscore.txt", "w");
        fprintf(fp, "%d",highscore2);
        fclose(fp);
        fp = fopen("/sd/thirdscore.txt", "w");
        fprintf(fp, "%d",highscore3);
        fclose(fp);
        fp = fopen("/sd/fourthscore.txt", "w");
        fprintf(fp, "%d",highscore4);
        fclose(fp);
        fp = fopen("/sd/fifthscore.txt", "w");
        fprintf(fp, "%d",highscore5);
        fclose(fp);
        sprintf(name5,name4);
        sprintf(name4,name3);
        sprintf(name3,name2);
        sprintf(name2,name);
        fp = fopen("/sd/secondname.txt", "w");
        fprintf(fp, name2);
        fclose(fp);
        fp = fopen("/sd/thirdname.txt", "w");
        fprintf(fp, name3);
        fclose(fp);
        fp = fopen("/sd/fourthname.txt", "w");
        fprintf(fp, name4);
        fclose(fp);
        fp = fopen("/sd/fifthname.txt", "w");
        fprintf(fp, name5);
        fclose(fp);
    } else if(score_counter>=highscore3) {
        highscore5=highscore4;
        highscore4=highscore3;
        highscore3=score_counter;
        lcd.clear();
        lcd.printString("New Highscore!",0,2);
        wait(2.0);
        register_name();
        fp = fopen("/sd/thirdscore.txt", "w");
        fprintf(fp, "%d",highscore3);
        fclose(fp);
        fp = fopen("/sd/fourthscore.txt", "w");
        fprintf(fp, "%d",highscore4);
        fclose(fp);
        fp = fopen("/sd/fifthscore.txt", "w");
        fprintf(fp, "%d",highscore5);
        fclose(fp);
        sprintf(name5,name4);
        sprintf(name4,name3);
        sprintf(name3,name);
        fp = fopen("/sd/thirdname.txt", "w");
        fprintf(fp, name3);
        fclose(fp);
        fp = fopen("/sd/fourthname.txt", "w");
        fprintf(fp, name4);
        fclose(fp);
        fp = fopen("/sd/fifthname.txt", "w");
        fprintf(fp, name5);
        fclose(fp);
    } else if(score_counter>=highscore4) {
        highscore5=highscore4;
        highscore4=score_counter;
        lcd.clear();
        lcd.printString("New Highscore!",0,2);
        wait(2.0);
        register_name();
        fp = fopen("/sd/fourthscore.txt", "w");
        fprintf(fp, "%d",highscore4);
        fclose(fp);
        fp = fopen("/sd/fifthscore.txt", "w");
        fprintf(fp, "%d",highscore5);
        fclose(fp);
        sprintf(name5,name4);
        sprintf(name4,name);
        fp = fopen("/sd/fourthname.txt", "w");
        fprintf(fp, name4);
        fclose(fp);
        fp = fopen("/sd/fifthname.txt", "w");
        fprintf(fp, name5);
        fclose(fp);
    } else if(score_counter>=highscore5) {
        highscore5=score_counter;
        lcd.clear();
        lcd.printString("New Highscore!",0,2);
        wait(2.0);
        register_name();
        fp = fopen("/sd/fifthscore.txt", "w");
        fprintf(fp, "%d",highscore5);
        fclose(fp);
        sprintf(name5,name);
        fp = fopen("/sd/fifthname.txt", "w");
        fprintf(fp, name5);
        fclose(fp);
    }
}

void register_name()
{
    name[0]='A';
    name[1]='A';
    name[2]='A';
    letter_counter=0;
    letter=0;
    letter1=0;
    letter2=0;
    letter3=0;
    while(!joystick.button) {
        if(up_flag) {
            up_flag=0;
            update_joystick();
        }
        lcd.clear();
        switch(letter) {
            case 0:
                if(letter_counter>=2) {
                    lcd.setPixel(32,24);
                    lcd.setPixel(33,24);
                    lcd.setPixel(34,24);
                    lcd.setPixel(35,24);
                    lcd.setPixel(36,24);
                    if(letter_counter==4) {
                        letter_counter=0;
                    } else {
                        letter_counter++;
                    }
                } else {
                    letter_counter++;
                }
                switch(letter1) {
                    case 0:
                        name[0]='A';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1=25;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 1:
                        name[0]='B';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 2:
                        name[0]='C';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 3:
                        name[0]='D';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 4:
                        name[0]='E';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 5:
                        name[0]='F';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 6:
                        name[0]='G';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 7:
                        name[0]='H';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 8:
                        name[0]='I';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 9:
                        name[0]='J';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 10:
                        name[0]='K';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 11:
                        name[0]='L';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 12:
                        name[0]='M';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 13:
                        name[0]='N';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 14:
                        name[0]='O';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 15:
                        name[0]='P';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 16:
                        name[0]='Q';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 17:
                        name[0]='R';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 18:
                        name[0]='S';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 19:
                        name[0]='T';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 20:
                        name[0]='U';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 21:
                        name[0]='V';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 22:
                        name[0]='W';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 23:
                        name[0]='X';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 24:
                        name[0]='Y';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1++;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                    case 25:
                        name[0]='Z';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter1=0;
                        } else if(joystick.direction==UP) {
                            letter1--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        }
                        break;
                }
                break;
            case 1:
                if(letter_counter>=2) {
                    lcd.setPixel(38,24);
                    lcd.setPixel(39,24);
                    lcd.setPixel(40,24);
                    lcd.setPixel(41,24);
                    lcd.setPixel(42,24);
                    if(letter_counter==4) {
                        letter_counter=0;
                    } else {
                        letter_counter++;
                    }
                } else {
                    letter_counter++;
                }
                switch(letter2) {
                    case 0:
                        name[1]='A';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2=25;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 1:
                        name[1]='B';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 2:
                        name[1]='C';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 3:
                        name[1]='D';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 4:
                        name[1]='E';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 5:
                        name[1]='F';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 6:
                        name[1]='G';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 7:
                        name[1]='H';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 8:
                        name[1]='I';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 9:
                        name[1]='J';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 10:
                        name[1]='K';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 11:
                        name[1]='L';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 12:
                        name[1]='M';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 13:
                        name[1]='N';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 14:
                        name[1]='O';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 15:
                        name[1]='P';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 16:
                        name[1]='Q';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 17:
                        name[1]='R';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 18:
                        name[1]='S';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 19:
                        name[1]='T';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 20:
                        name[1]='U';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 21:
                        name[1]='V';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 22:
                        name[1]='W';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 23:
                        name[1]='X';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 24:
                        name[1]='Y';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2++;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 25:
                        name[1]='Z';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter2=0;
                        } else if(joystick.direction==UP) {
                            letter2--;
                        }
                        if(joystick.direction==RIGHT) {
                            letter++;
                        } else if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                }
                break;
            case 2:
                if(letter_counter>=2) {
                    lcd.setPixel(44,24);
                    lcd.setPixel(45,24);
                    lcd.setPixel(46,24);
                    lcd.setPixel(47,24);
                    lcd.setPixel(48,24);
                    if(letter_counter==4) {
                        letter_counter=0;
                    } else {
                        letter_counter++;
                    }
                } else {
                    letter_counter++;
                }
                switch(letter3) {
                    case 0:
                        name[2]='A';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3=25;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 1:
                        name[2]='B';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 2:
                        name[2]='C';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 3:
                        name[2]='D';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 4:
                        name[2]='E';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 5:
                        name[2]='F';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 6:
                        name[2]='G';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 7:
                        name[2]='H';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 8:
                        name[2]='I';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 9:
                        name[2]='J';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 10:
                        name[2]='K';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 11:
                        name[2]='L';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 12:
                        name[2]='M';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 13:
                        name[2]='N';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 14:
                        name[2]='O';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 15:
                        name[2]='P';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 16:
                        name[2]='Q';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 17:
                        name[2]='R';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 18:
                        name[2]='S';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 19:
                        name[2]='T';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 20:
                        name[2]='U';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 21:
                        name[2]='V';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 22:
                        name[2]='W';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 23:
                        name[2]='X';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 24:
                        name[2]='Y';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3++;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                    case 25:
                        name[2]='Z';
                        lcd.printChar(name[0],32,2);
                        lcd.printChar(name[1],38,2);
                        lcd.printChar(name[2],44,2);
                        wait(g_dt);
                        if(joystick.direction==DOWN) {
                            letter3=0;
                        } else if(joystick.direction==UP) {
                            letter3--;
                        }
                        if(joystick.direction==LEFT) {
                            letter--;
                        }
                        break;
                }
                break;
        }
        sleep();
    }
    buzzer.tone(NOTE_C4,SEMIQUAVER);
}

void rules()
{
    wait(g_dt);
    lcd.clear();
    while(!joystick.bbutton) {
        if(up_flag) {
            up_flag=0;
            update_joystick();
        }
        lcd.clear();
        bat1.draw(0,7);
        spike_small_obj1.draw(0,23);
        spike_large_obj1.draw(6,23);
        lcd.printString("These are",14,0);
        lcd.printString("your health.",14,1);
        lcd.printString("Avoid these",14,2);
        lcd.printString("or you'll",14,3);
        lcd.printString("die!",14,4);
        lcd.printString("GOOD LUCK!",14,5);
        lcd.refresh();
        sleep();
    }
    buzzer.tone(NOTE_D3,SEMIQUAVER);
    menu();
}

void credits()
{
    wait(g_dt);
    lcd.clear();
    lcd.printString("Cave Runner",10,0);
    lcd.printString("A Game By",13,2);
    lcd.printString("Marty Laverick",0,3);
    lcd.printString("Created For",9,4);
    lcd.printString("ELEC2645",14,5);
    while(!joystick.bbutton) {
        if(up_flag) {
            up_flag=0;
            update_joystick();
        }
        sleep();
    }
    buzzer.tone(NOTE_D3,SEMIQUAVER);
    menu();
}