/**
@file drawings.h
@brief Header file containing function prototypes, defines and global variables for the drawings.cpp file.
@brief Version 1.0.0
@author Marty Laverick
@date 5th May 2016
*/

#ifndef _DRAWINGS_H
#define _DRAWINGS_H

#include "mbed.h"
#include "N5110.h"

#define BG 0
#define GAME 1
#define HEALTH 2

extern N5110 lcd;

const char pointer[5][5]= {
   //0,1,2,3,4
    {1,1,0,0,0},//0
    {0,0,1,1,0},//1
    {0,0,0,1,1},//2
    {0,0,1,1,0},//3
    {1,1,0,0,0} //4
};  /*!< Pointer bitmap */

const char player_still[15][13]= {
   //0,1,2,3,4,5,6,7,8,9,a,b,c
    {0,0,0,0,1,0,0,1,0,0,0,0,0},//0
    {0,0,0,1,1,1,1,1,1,0,0,0,0},//1
    {0,0,1,2,1,2,2,1,1,1,1,1,0},//2
    {0,0,1,2,1,2,1,2,1,2,2,2,1},//3
    {0,1,1,2,2,1,2,2,1,1,1,1,1},//4
    {1,2,1,1,1,2,2,2,1,0,0,0,0},//5
    {1,2,2,1,1,1,1,1,1,0,0,0,0},//6
    {1,2,2,2,1,2,2,1,2,1,0,0,0},//7
    {0,1,2,2,1,2,2,1,2,1,0,0,0},//8
    {0,0,1,1,1,1,1,1,1,1,0,0,0},//9
    {0,0,0,0,1,2,2,1,2,1,0,0,0},//a
    {0,0,0,0,1,2,2,2,2,1,0,0,0},//b
    {0,0,0,0,0,1,1,1,1,0,0,0,0},//c
    {0,0,0,0,1,1,1,1,0,0,0,0,0},//d
    {0,0,0,0,0,1,1,0,0,0,0,0,0} //e
};  /*!< Player bitmap */

const char player_moving1[15][13]= {
   //0,1,2,3,4,5,6,7,8,9,a,b,c
    {0,0,0,1,0,0,0,1,0,0,0,0,0},//0
    {0,1,0,0,1,1,1,1,1,0,0,0,0},//1
    {1,2,1,0,1,2,2,1,1,1,0,0,0},//2
    {1,2,2,1,1,2,1,2,1,2,1,0,0},//3
    {0,1,2,2,2,1,2,2,1,1,2,1,0},//4
    {1,2,1,1,1,2,2,2,1,0,1,2,1},//5
    {1,2,2,1,1,1,1,1,1,0,0,1,1},//6
    {1,2,2,2,1,2,2,1,2,1,0,0,0},//7
    {0,1,2,2,1,2,2,1,2,1,0,0,0},//8
    {0,0,1,1,1,1,1,1,1,1,0,0,0},//9
    {0,0,0,0,1,2,2,1,2,1,0,0,0},//a
    {0,0,0,0,1,2,2,2,2,1,0,0,0},//b
    {0,0,0,0,0,1,1,1,1,0,0,0,0},//c
    {0,0,0,0,1,1,1,1,0,0,0,0,0},//d
    {0,0,0,0,0,1,1,0,0,0,0,0,0} //e
};  /*!< Player first moving transition bitmap */

const char player_moving2[15][13]= {
   //0,1,2,3,4,5,6,7,8,9,a,b,c
    {0,0,0,0,1,0,1,0,0,0,0,1,1},//0
    {0,0,0,0,1,1,1,1,1,0,1,2,1},//1
    {0,0,0,0,1,2,1,1,1,1,2,1,0},//2
    {0,0,1,1,2,2,1,2,1,2,1,0,0},//3
    {0,1,1,2,2,1,2,2,1,1,0,0,0},//4
    {1,2,1,2,1,2,2,2,1,0,0,0,0},//5
    {1,2,2,1,1,1,1,1,1,0,0,0,0},//6
    {1,2,2,2,1,2,2,1,2,1,0,0,0},//7
    {0,1,2,2,1,2,2,1,2,1,0,0,0},//8
    {0,0,1,1,1,1,1,1,1,1,0,0,0},//9
    {0,0,0,0,1,2,2,1,2,1,0,0,0},//a
    {0,0,0,0,1,2,2,2,2,1,0,0,0},//b
    {0,0,0,0,0,1,1,1,1,0,0,0,0},//c
    {0,0,0,0,1,1,1,1,0,0,0,0,0},//d
    {0,0,0,0,0,1,1,0,0,0,0,0,0} //e
};  /*!< Player second moving transition bitmap */

const char player_jumping[15][13]= {
   //0,1,2,3,4,5,6,7,8,9,a,b,c
    {0,0,0,1,0,0,1,0,0,0,0,0,0},//0
    {0,0,0,0,1,1,1,1,1,0,0,0,0},//1
    {0,0,0,0,1,2,2,1,1,0,0,0,0},//2
    {0,0,1,1,1,1,1,2,1,0,0,0,0},//3
    {0,1,2,2,1,2,1,2,1,1,0,0,0},//4
    {1,2,2,2,1,2,1,1,1,2,1,0,0},//5
    {1,2,2,2,1,2,2,1,1,1,2,1,0},//6
    {1,2,2,2,1,1,2,1,2,1,1,2,1},//7
    {0,1,2,2,1,2,1,1,2,1,0,1,1},//8
    {0,0,1,1,1,1,1,1,1,1,0,0,0},//9
    {0,0,0,0,1,2,2,1,2,1,0,0,0},//a
    {0,0,0,0,1,2,2,2,2,1,0,0,0},//b
    {0,0,0,0,0,1,1,1,1,0,0,0,0},//c
    {0,0,0,0,1,1,1,1,0,0,0,0,0},//d
    {0,0,0,0,0,1,1,0,0,0,0,0,0} //e
};  /*!< Player jumping bitmap */

const char spike_small[5][5]= {
   //0,1,2,3,4
    {1,2,2,2,1},//0
    {1,2,2,2,1},//1
    {0,1,2,1,0},//2
    {0,1,2,1,0},//3
    {0,0,1,0,0} //4
};  /*!< Small spike bitmap */

const char spike_large[8][6]= {
   //0,1,2,3,4,5
    {1,2,2,2,2,1},//0
    {1,2,2,2,2,1},//1
    {1,2,2,2,2,1},//2
    {1,2,2,2,1,0},//3
    {0,1,2,2,1,0},//4
    {0,1,2,2,1,0},//5
    {0,1,2,2,1,0},//6
    {0,0,1,1,0,0} //7
};  /*!< Large spike bitmap */

const char bat_middle[7][13]= {
   //0,1,2,3,4,5,6,7,8,9,a,b,c
    {0,0,0,0,0,1,0,1,0,0,0,0,0},//0
    {0,0,0,0,0,1,1,1,0,0,0,0,0},//1
    {0,0,1,1,1,1,1,1,1,1,1,0,0},//2
    {0,0,1,1,1,1,1,1,1,1,1,0,0},//3
    {0,0,0,1,1,1,1,1,1,1,0,0,0},//4
    {0,0,0,0,1,1,1,1,1,0,0,0,0},//5
    {0,0,0,0,0,1,0,1,0,0,0,0,0} //6
};  /*!< Bat wings flappin transition bitmap */

const char bat_open[7][13]= {
   //0,1,2,3,4,5,6,7,8,9,a,b,c
    {0,0,0,0,0,1,0,1,0,0,0,0,0},//0
    {0,0,0,0,0,1,1,1,0,0,0,0,0},//1
    {1,1,1,1,1,1,1,1,1,1,1,1,1},//2
    {0,1,1,1,1,1,1,1,1,1,1,1,0},//3
    {0,0,0,1,1,1,1,1,1,1,0,0,0},//4
    {0,0,0,0,1,1,1,1,1,0,0,0,0},//5
    {0,0,0,0,0,1,0,1,0,0,0,0,0} //6
};  /*!< Bat with open wings bitmap */

const char bat_close[7][13]= {
   //0,1,2,3,4,5,6,7,8,9,a,b,c
    {0,0,0,0,0,1,0,1,0,0,0,0,0},//0
    {0,0,0,0,0,1,1,1,0,0,0,0,0},//1
    {0,0,0,0,1,1,1,1,1,0,0,0,0},//2
    {0,0,0,1,1,1,1,1,1,1,0,0,0},//3
    {0,0,0,1,1,1,1,1,1,1,0,0,0},//4
    {0,0,0,0,1,1,1,1,1,0,0,0,0},//5
    {0,0,0,0,0,1,0,1,0,0,0,0,0} //6
};  /*!< Bat with closed wings bitmap */

const char mark_ver[5][3]= {
   //0,1,2
    {0,1,0},//0
    {0,0,1},//1
    {1,0,1},//2
    {1,0,0},//3
    {0,1,0} //4
};  /*!< Vertical mark bitmap */

const char mark_hor[3][5]= {
   //0,1,2,3,4
    {0,0,1,1,0},//0
    {1,0,0,0,1},//1
    {0,1,1,0,0} //2
};  /*!< Horizontal mark bitmap */

const char rocks[4][6]= {
   //0,1,2,3,4,5
    {1,2,1,2,2,1},//0
    {1,2,2,1,1,0},//1
    {0,1,2,2,1,0},//2
    {0,0,1,1,0,0} //3
};  /*!< Rocks bitmap */

class Screen
{
    public:
    /** Create a Screen object
    */
    Screen() {};
    /** Initialise Screen
    *
    *   Sets all the elements in the array to 0.
    */
    void init();
    /** Set a Pixel
    *
    *   This function sets a pixel in the array.
    *   @param  x - the x co-ordinate of the pixel (0 to 83)
    *   @param  y - the y co-ordinate of the pixel (0 to 47)
    *   @param layer - the layer co-ordinate of the pixel (0 to 2)
    */
    void set_pixel(int x, int y, int layer);
    /** Clear a Pixel
    *
    *   This function clears a pixel in the array.
    *   @param  x - the x co-ordinate of the pixel (0 to 83)
    *   @param  y - the y co-ordinate of the pixel (0 to 47)
    *   @param layer - the layer co-ordinate of the pixel (0 to 2)
    */
    void clear_pixel(int x, int y, int layer);
    /** Clear a Layer
    *
    *   This function clears a layer in the array.
    *   @param layer - the layer co-ordinate of the pixel (0 to 2)
    */
    void clear_layer(int layer);
    /** Set a Pixel
    *
    *   This function clears the array.
    */
    void clear();
    /** Draw a Layer
    *
    *   This function displays a layer in the array.
    *   @param layer - the layer co-ordinate of the pixel (0 to 2)
    */
    void draw_layer(int layer);
    /** Draw all Layers
    *
    *   This function displays all layers in the array.
    */
    void draw();
    /** Get a Pixel
    *
    *   This function gets the status of a pixel in the array.
    *   @param  x - the x co-ordinate of the pixel (0 to 83)
    *   @param  y - the y co-ordinate of the pixel (0 to 47)
    *   @param layer - the layer co-ordinate of the pixel (0 to 2)
    *   @returns
    *       0       - pixel is clear
    *       1       - pixel is set
    */
    bool get_pixel(int x, int y, int layer);
    char layers[48][84][3]; //[y][x][(0 is the background, 1 is the game and 2 is health)]
};

class object
{
    public:
    /** Create an object object
    */
    object() {};
    /** Create an object object with the specified width and height
    *
    * Sets the array line to be of size [height][width].
    * @param _width - the width of the object
    * @param _height - the height of the object
    *
    */
    object(int _width,int _height):width(_width),height(_height) {
        line = new char*[height];
        for(int i=0; i<height; i++) {
            line[i] = new char[width];
        }
    };
    /** Fills Line Array
    *
    *   Sets the elements of the line array.
    */
    void fill(const char array[][3]);
    /** Fills Line Array
    *
    *   Sets the elements of the line array.
    */
    void fill(const char array[][5]);
    /** Fills Line Array
    *
    *   Sets the elements of the line array.
    */
    void fill(const char array[][6]);
    /** Fills Line Array
    *
    *   Sets the elements of the line array.
    */
    void fill(const char array[][13]);
    /** Fills Line Array
    *
    *   Sets the elements of the line array.
    */
    void fill(const char array[][25]);
    /** Draw Line
    *
    *   This function displays the line array.
    *   @param  x - the x co-ordinate of the pixel (0 to 83)
    *   @param  y - the y co-ordinate of the pixel (0 to 47)
    */
    void draw(int x,int y);
    /** Draw Line
    *
    *   This function sets the line array in a layer of the Screen.
    *   @param  x - the x co-ordinate of the pixel (0 to 83)
    *   @param  y - the y co-ordinate of the pixel (0 to 47)
    *   @param layer - the layer co-ordinate of the pixel (0 to 2)
    */
    void draw_screen(int x, int y, int layer);
    /** Set Array
    *
    *   Sets the array line to be of size [height][width].
    *   @param _width - the width of the object
    *   @param _height - the height of the object
    */
    void set(int _width,int _height);
    /** Checks Collisions
    *
    *   This function checks the horizontal pixels above the object for a turned on pixel
    *   @param  x - the x co-ordinate of the pixel (0 to 83)
    *   @param  y - the y co-ordinate of the pixel (0 to 47)
    *   @returns
    *       0       - no collision
    *       1       - collision
    */
    bool check_collision(int x, int y);
    
    private:
    int width;
    int height;
    char **line;
};

class animation
{
    public:
    /** Create an animation object with the specified width and height and arrays to make the animation
    *
    * Sets the array line to be of size [height][width] and makes objects for each animation state.
    * @param _width - the width of the object
    * @param _height - the height of the object
    *
    */
    animation(int _width,int _height,const char _array1[][13],const char _array2[][13],const char _array3[][13]):width(_width),height(_height) {
        state1.set(width,height);
        state2.set(width,height);
        state3.set(width,height);
        state1.fill(_array1);
        state2.fill(_array2);
        state3.fill(_array3);
        state = 0;
        next = 0;
        divider = 2;
        counter = 0;
    }
    /** Draw State
    *
    *   This function displays the state.
    *   @param  x - the x co-ordinate of the pixel (0 to 83)
    *   @param  y - the y co-ordinate of the pixel (0 to 47)
    */
    void draw(int x,int y);
    /** Draw State
    *
    *   This function sets the state in a layer of the Screen.
    *   @param  x - the x co-ordinate of the pixel (0 to 83)
    *   @param  y - the y co-ordinate of the pixel (0 to 47)
    *   @param layer - the layer co-ordinate of the pixel (0 to 2)
    */
    void draw_screen(int x, int y, int layer);
    char counter;
    char state;
    char next;
    
    private:
    int width;
    int height;
    object state1;
    object state2;
    object state3;
    char divider;
};

class Background
{
    public:
    /** Create a Background object and initialises the objects used in it
    */
    Background() {
        //Objects
        mark_ver_obj.set(3,5);
        mark_hor_obj.set(5,3);
        rocks_obj.set(6,4);
        mark_ver_obj.fill(mark_ver);
        mark_hor_obj.fill(mark_hor);
        rocks_obj.fill(rocks);
        counter=0;
    };
    char wall[48][84];
    char counter;
    /** Initialise Background
    *
    *   Sets all the elements in the array to 0.
    *   draws the objects into the array.
    */
    void init();
    /** Fill Background
    *
    *   Sets all the elements in the array to the elements from the Screen.
    */
    void fill(char array[48][84][3]);
    /** Draw Background
    *
    *   This function displays the array.
    */
    void draw();
    /** Draw Screen
    *
    *   This function sets the array to the BG sub-array.
    *   @param layer - the layer co-ordinate of the pixel (0 to 2)
    */
    void draw_screen(int layer);
    
    private:
    object mark_ver_obj;
    object mark_hor_obj;
    object rocks_obj;
};

#endif