/**
@file drawings.cpp

@brief Member functions implementations

*/

#include "drawings.h"

extern Screen screen;

void Screen::init()
{
    for(int i=0; i<3; i++) {
        for(int j=0; j<48; j++) {
            for(int k=0; k<84; k++) {
                layers[j][k][i]=0;
            }
        }
    }
}

void Screen::set_pixel(int x, int y, int layer)
{
    layers[y][x][layer]=1;
}

void Screen::clear_pixel(int x, int y, int layer)
{
    layers[y][x][layer]=2;
}

void Screen::clear_layer(int layer)
{
    for(int i=0; i<48; i++) {
        for(int j=0; j<84; j++) {
            layers[i][j][layer]=0;
        }
    }
}

void Screen::clear()
{
    for(int i=0; i<3; i++) {
        clear_layer(i);
    }
}

void Screen::draw_layer(int layer)
{
    for(int i=0; i<48; i++) {
        for(int j=0; j<84; j++) {
            switch(layers[i][j][layer]) {
                case 1:
                    lcd.setPixel(j,i);
                    break;
                case 2:
                    lcd.clearPixel(j,i);
                    break;
                default:
                    break;
            }
        }
    }
}

void Screen::draw()
{
    for(int i=0; i<3; i++) {
        draw_layer(i);
    }
}

bool Screen::get_pixel(int x, int y, int layer)
{
    return layers[y][x][layer];
}

void object::fill(const char array[][3])
{
    for(int i=0; i<height; i++) {
        for(int j=0; j<width; j++) {
            line[i][j] = array[i][j];
        }
    }
}

void object::fill(const char array[][5])
{
    for(int i=0; i<height; i++) {
        for(int j=0; j<width; j++) {
            line[i][j] = array[i][j];
        }
    }
}

void object::fill(const char array[][6])
{
    for(int i=0; i<height; i++) {
        for(int j=0; j<width; j++) {
            line[i][j] = array[i][j];
        }
    }
}

void object::fill(const char array[][13])
{
    for(int i=0; i<height; i++) {
        for(int j=0; j<width; j++) {
            line[i][j] = array[i][j];
        }
    }
}

void object::fill(const char array[][25])
{
    for(int i=0; i<height; i++) {
        for(int j=0; j<width; j++) {
            line[i][j] = array[i][j];
        }
    }
}

void object::draw(int x,int y)
{
    for(int i=0; i < height; i++) {
        for(int j=0; j < width; j++) {
            switch(line[i][j]) {
                case 1:
                    lcd.setPixel(x+j,y-i);
                    break;
                case 2:
                    lcd.clearPixel(x+j,y-i);
                    break;
                default:
                    break;
            }
        }
    }
}

void object::draw_screen(int x,int y, int layer)
{
    for(int i=0; i < height; i++) {
        for(int j=0; j < width; j++) {
            switch(line[i][j]) {
                case 1:
                    screen.set_pixel(x+j,y-i,layer);
                    break;
                case 2:
                    screen.clear_pixel(x+j,y-i,layer);
                    break;
                default:
                    break;
            }
        }
    }
}

void object::set(int _width,int _height)
{
    width = _width;
    height = _height;
    line = new char*[height];
    for(int i=0; i<height; i++) {
        line[i] = new char[width];
    }
}

bool object::check_collision(int x, int y)
{
    for(int j=0; j<width; j++) {
        if(screen.get_pixel(x+j,y-height,GAME)) {
            return 1;
        }
    }
    return 0;
}

void animation::draw(int x,int y)
{
    switch(state)
    {
        case 0:
            state1.draw(x,y);
            if(counter == divider)
            {
                counter = 0;
                if(next == 0)
                {
                    state = 1;
                    break;
                }
                else
                {
                    state = 2;
                    break;
                }
            }
            else
            {
                counter++;
                break;
            }
        case 1:
            state2.draw(x,y);
            if(counter == divider)
            {
                counter = 0;
                state = 0;
                next = 1;
                break;
            }
            else
            {
                counter++;
                break;
            }
        case 2:
            state3.draw(x,y);
            if(counter == divider)
            {
                counter = 0;
                state = 0;
                next = 0;
                break;
            }
            else
            {
                counter++;
                break;
            }
    }
}

void animation::draw_screen(int x,int y, int layer)
{
    switch(state)
    {
        case 0:
            state1.draw_screen(x,y,layer);
            if(counter == divider)
            {
                counter = 0;
                if(next == 0)
                {
                    state = 1;
                    break;
                }
                else
                {
                    state = 2;
                    break;
                }
            }
            else
            {
                counter++;
                break;
            }
        case 1:
            state2.draw_screen(x,y,layer);
            if(counter == divider)
            {
                counter = 0;
                state = 0;
                next = 1;
                break;
            }
            else
            {
                counter++;
                break;
            }
        case 2:
            state3.draw_screen(x,y,layer);
            if(counter == divider)
            {
                counter = 0;
                state = 0;
                next = 0;
                break;
            }
            else
            {
                counter++;
                break;
            }
    }
}

void Background::init()
{
    for(int i=0; i<48; i++) {
        for(int j=0; j<84; j++) {
            wall[i][j]=0;
        }
    }
    //sets the mark_ver's
    mark_hor_obj.draw_screen(21,22,BG);
    mark_ver_obj.draw_screen(36,36,BG);
    mark_ver_obj.draw_screen(55,12,BG);
    mark_hor_obj.draw_screen(68,18,BG);
    mark_ver_obj.draw_screen(81,28,BG);
    //sets the mark_hor's
    mark_hor_obj.draw_screen(7,14,BG);
    mark_hor_obj.draw_screen(18,23,BG);
    mark_hor_obj.draw_screen(31,24,BG);
    mark_ver_obj.draw_screen(42,11,BG);
    mark_ver_obj.draw_screen(76,37,BG);
    //sets the rocks'
    rocks_obj.draw_screen(13,42,BG);
    rocks_obj.draw_screen(38,42,BG);
    rocks_obj.draw_screen(65,42,BG);
}

void Background::fill(char array[48][84][3])
{
    for(int i=0; i<48; i++) {
        for(int j=0; j<84; j++) {
            wall[i][j] = array[i][j][BG];
        }
    }
}

void Background::draw()
{
    int x;
    for(int i=83; i>-1; i--) {
        for(int j=0; j<48; j++) {
            switch(wall[j][i]) {
                case 1:
                    if((i-counter)>=0) {
                        x=i-counter;
                    } else {
                        x=84+(i-counter);
                    }
                    lcd.setPixel(x,j);
                    break;
                case 2:
                    if((i-counter)>=0) {
                        x=i-counter;
                    } else {
                        x=84+(i-counter);
                    }
                    lcd.clearPixel(x,j);
                    break;
                default:
                    break;
            }
        }
    }
    counter++;
    if(counter>84) {
        counter=0;
    }
}

void Background::draw_screen(int layer)
{
    int x;
    for(int i=83; i>-1; i--) {
        for(int j=0; j<48; j++) {
            switch(wall[j][i]) {
                case 1:
                    if((i-counter)>=0) {
                        x=i-counter;
                    } else {
                        x=84+(i-counter);
                    }
                    screen.set_pixel(x,j,layer);
                    break;
                case 2:
                    if((i-counter)>=0) {
                        x=i-counter;
                    } else {
                        x=84+(i-counter);
                    }
                    screen.clear_pixel(x,j,layer);
                    break;
                default:
                    break;
            }
        }
    }
    counter++;
    if(counter>84) {
        counter=0;
    }
}