
#include <stm32f3_discovery.h>

volatile  unsigned	sysTiming;
volatile  unsigned  sysTicks = 0;

void SysTick_Handler(void) {
        sysTicks++;
        if (sysTiming > 0) --sysTiming; 
}

void sysDelayMs(unsigned dly) {
	sysTiming = dly;
	while (sysTiming > 0) __wfi();

}

int main(void) {
    
    SysTick_Config((SystemCoreClock / 1000));
    RCC->AHBENR |= RCC_AHBPeriph_GPIOE | RCC_AHBPeriph_GPIOA;    
    GPIOE->MODER = (GPIOE->MODER&0xffff) | 0x55550000; // output mode for PE8-15
	GPIOA->MODER = (GPIOA->MODER&0xfffffffc)  ; // input mode for PA0

    GPIOE->BSRR=0xff00;
    sysDelayMs(500);
    int b=0;
	while(1) {
    	GPIOE->BSRR=1<<(b+8);
    	while(GPIOA->IDR&1);
    	sysDelayMs(100);
    	GPIOE->BSRR=1<<(b+8+16);
    	b=(b+1)%8;
    }
}


