
#include <stm32f3_discovery.h>

// example code to spin the LEDs on the discovery board by writing to the GPIO device registers directly

int main(void) {

    RCC->AHBENR |= RCC_AHBPeriph_GPIOE | RCC_AHBPeriph_GPIOA; // enable clocks for GPIOA and GPIOE
    GPIOE->MODER = (GPIOE->MODER & 0xffff) | 0x55550000; 	// output mode for PE8-15 (LEDs 0-7)
	GPIOA->MODER = (GPIOA->MODER & 0xfffffffc)  ; 			// input mode for PA0 (User Button)
    GPIOE->ODR &= 0x00ff; // switch all LEDs off by clearing bits 8..15
    
    int b=1;	// start with top LED (GPIOE9)
    while(1) {  // loop forever
    	GPIOE->ODR |= 1<<(b+8);		// switch on LED b by setting bit 8+b 
    	while(GPIOA->IDR & 1);		// wait while button is pressed
    	for(int j=0;j<1000000;j++);	// wait for about .1 seconds
    	GPIOE->ODR&=0x00ff;			// switch all LEDs off
    	b=(b+1)%8;					// move on to next LED
    }
}
