
#include <stm32f3_discovery.h>

volatile  unsigned	sysTiming;
volatile  unsigned  sysTicks = 0;

void SysTick_Handler(void) {
        sysTicks++;
        if (sysTiming > 0) --sysTiming; 
}

void sysDelayMs(unsigned dly) {
	//dly=dly;
	sysTiming = dly;
	while (sysTiming > 0) __wfi();

}


void EXTI0_IRQHandler() {
	if(EXTI->PR & 1) {
		GPIOE->ODR ^= 0xff00;
		//EXTI->PR |= 1;
	}
}

int main(void) {
    
    SysTick_Config((SystemCoreClock / 1000));
    RCC->AHBENR |= RCC_AHBPeriph_GPIOE | RCC_AHBPeriph_GPIOA;    
    RCC->APB2ENR |= RCC_APB2ENR_SYSCFGEN;
    GPIOE->MODER = (GPIOE->MODER&0xffff) | 0x55550000; // output mode for PE8-15
	GPIOA->MODER = (GPIOA->MODER&0xfffffffc)  ; // input mode for PA0
	SYSCFG->EXTICR[0] &= ~0xf;
	EXTI->IMR |= 1; // int enable
	EXTI->RTSR |= 1; // rising
	EXTI->FTSR &= ~1; // falling
	NVIC->IP[EXTI0_IRQn]=32; // Interrupt Priority, lower is higher priority
	NVIC->ISER[EXTI0_IRQn >> 0x05] = 1 << (EXTI0_IRQn & 0x1F); // Interrupt enable
    GPIOE->BSRR=0xff00;
    sysDelayMs(500);
    int b=0;
	while(1) {
    	GPIOE->BSRR=1<<(b+8);
    	//while(GPIOA->IDR&1);
    	sysDelayMs(100);
    	GPIOE->BSRR=1<<(b+8+16);
    	b=(b+1)%8;
    }
}


