
#include <stm32f3_discovery.h>
#include <stm32f3_discovery_lsm303dlhc.h>

void AccelerometerConfig(void)
{
  LSM303DLHCMag_InitTypeDef LSM303DLHC_InitStructure;
  LSM303DLHCAcc_InitTypeDef LSM303DLHCAcc_InitStructure;
  LSM303DLHCAcc_FilterConfigTypeDef LSM303DLHCFilter_InitStructure;
  
  /* Configure MEMS magnetometer main parameters: temp, working mode, full Scale and Data rate */
  LSM303DLHC_InitStructure.Temperature_Sensor = LSM303DLHC_TEMPSENSOR_DISABLE;
  LSM303DLHC_InitStructure.MagOutput_DataRate =LSM303DLHC_ODR_30_HZ ;
  LSM303DLHC_InitStructure.MagFull_Scale = LSM303DLHC_FS_8_1_GA;
  LSM303DLHC_InitStructure.Working_Mode = LSM303DLHC_CONTINUOS_CONVERSION;
  LSM303DLHC_MagInit(&LSM303DLHC_InitStructure);
  
   /* Fill the accelerometer structure */
  LSM303DLHCAcc_InitStructure.Power_Mode = LSM303DLHC_NORMAL_MODE;
  LSM303DLHCAcc_InitStructure.AccOutput_DataRate = LSM303DLHC_ODR_50_HZ;
  LSM303DLHCAcc_InitStructure.Axes_Enable= LSM303DLHC_AXES_ENABLE;
  LSM303DLHCAcc_InitStructure.AccFull_Scale = LSM303DLHC_FULLSCALE_2G;
  LSM303DLHCAcc_InitStructure.BlockData_Update = LSM303DLHC_BlockUpdate_Continous;
  LSM303DLHCAcc_InitStructure.Endianness=LSM303DLHC_BLE_LSB;
  LSM303DLHCAcc_InitStructure.High_Resolution=LSM303DLHC_HR_ENABLE;
  /* Configure the accelerometer main parameters */
  LSM303DLHC_AccInit(&LSM303DLHCAcc_InitStructure);
  
  /* Fill the accelerometer LPF structure */
  LSM303DLHCFilter_InitStructure.HighPassFilter_Mode_Selection =LSM303DLHC_HPM_NORMAL_MODE;
  LSM303DLHCFilter_InitStructure.HighPassFilter_CutOff_Frequency = LSM303DLHC_HPFCF_16;
  LSM303DLHCFilter_InitStructure.HighPassFilter_AOI1 = LSM303DLHC_HPF_AOI1_DISABLE;
  LSM303DLHCFilter_InitStructure.HighPassFilter_AOI2 = LSM303DLHC_HPF_AOI2_DISABLE;

  /* Configure the accelerometer LPF main parameters */
  LSM303DLHC_AccFilterConfig(&LSM303DLHCFilter_InitStructure);
}

void ReadAccelerometer(int16_t * data) {  
  LSM303DLHC_Read(ACC_I2C_ADDRESS, LSM303DLHC_OUT_X_L_A, (uint8_t *)data, 6);
}

volatile  unsigned	sysTiming;
volatile  unsigned  sysTicks = 0;

void SysTick_Handler(void) {
        sysTicks++;
        if (sysTiming > 0) --sysTiming; 
}

void sysDelayMs(unsigned dly) {
	sysTiming = dly;
	while (sysTiming > 0) __wfi();

}

int main(void) {
    
    SysTick_Config((SystemCoreClock / 1000));
    RCC->AHBENR |= RCC_AHBPeriph_GPIOE | RCC_AHBPeriph_GPIOA;    
    GPIOE->MODER = (GPIOE->MODER&0xffff) | 0x55550000; // output mode for PE8-15
	GPIOA->MODER = (GPIOA->MODER&0xfffffffc)  ; // input mode for PA0

	AccelerometerConfig();
	int16_t acc[3];
    int b=0;
    int TH=200*16;
    while(1) {
    	
    	ReadAccelerometer(acc);
    	printf("Accelerometer: %d %d %d\n",acc[0]/16,acc[1]/16,acc[2]/16);
    	GPIOE->BSRR=b<<(8+16);
    	b=0;
    	if(acc[1]<-TH) {
    		 if(acc[0]<-TH) b=1<<4;
    		 	else if(acc[0]>TH) b=1<<2;
    		 		else b=1<<3;
    	} else {
    		if(acc[1]>TH) {
	    		 if(acc[0]<-TH) b=1<<6;
	    		 	else if(acc[0]>TH) b=1<<0;
    			 		else b=1<<7;
    		} else {
    			if(acc[0]<-TH) b=1<<5;
	    		 	else if(acc[0]>TH) b=1<<1;
    		}
    	}
    	GPIOE->BSRR=b<<8;
    	while(GPIOA->IDR&1);
    	sysDelayMs(100);
    	
    }
}

