#include <gdi.h>
#include <menu.h>
#include <video.h>
#include "stm32f30x.h"

void menu(menu_t *menu) {
    int n=menu->no;
    int selected=0;
    int16_t accel[3];
    MemsConfig();
    while(1) {
        gdiSetColour(3);
        gdiRectangle(0,0,(VID_HSIZE - 1),VID_VSIZE - 1,0);

        gdiSetColour(7);
        gdiDrawTextEx(VID_HSIZE/2-strlen(menu->title)*3, 16, menu->title, 0);
        for(int i=0;i<n;i++) {
            if(selected==i) {
                gdiSetColour(1);
                gdiFilledRectangle(12,i*12+15+16,16+strlen(menu->entries[i].name)*6+2,i*12+26+16,0);
                gdiSetColour(7);
            }
            else
                gdiSetColour(1);
            gdiDrawTextEx(16, i*12+32, menu->entries[i].name, 0);
        }
        if(buttonPress())
            menu->entries[selected].prog();
        ReadAccelerometer(accel );
        selected= accel[0]/2000+n/2;
        if(selected<0) selected=0;
        if(selected>n-1) selected=n-1;
        waitForRefresh();
        vidNextBuffer();

    }
}