/***************************************************************************
 * STM32 VGA demo
 * Copyright (C) 2012 Artekit Italy
 * http://www.artekit.eu
 * Written by Ruben H. Meleca
 
### main.c
 
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#include "stm32f30x.h"
#include "sys.h"
#include "video.h"
#include "gdi.h"
#include "menu.h"

extern void demoInit(void);

void RCC_Configuration(void) {
	RCC->AHBENR |= RCC_AHBENR_GPIOAEN | RCC_AHBENR_GPIOEEN ;
}
extern void bounce(),conway_demo(),bubble_demo(),rotozoom(),cube_demo();
menuentry_t entries[]={{"Ball Game",bounce},{"Game Of Life",conway_demo},{"Bubbles",bubble_demo},{"Graphics Demo",demoInit},{"RotoZoom",rotozoom},{"Cube",cube_demo}};
menu_t mainmenu={"Demo Menu",sizeof(entries)/sizeof(menuentry_t),entries};

void GPIO_Configuration(void) {
    GPIOE->MODER = (GPIOE->MODER&0xffff) | 0x55550000; // output mode for PE8-15
	GPIOA->MODER = (GPIOA->MODER&0xfffffffc)  ; // input mode for PA0
	GPIOA->PUPDR = (GPIOA->PUPDR & ~0x3) | 0x2; // pull down (10)
}
extern void siInit(void);
int main(void) {
 	RCC_Configuration();
	GPIO_Configuration();
	vidInit();
	sysInitSystemTimer();
	menu(&mainmenu);
	if(GPIOA->IDR & 1)
		demoInit();
	else
		bounce();
	return 0;
}

