#include "stm32f30x.h"
#include "sys.h"
#include "video.h"
#include "gdi.h"
#include <string.h>
#include <stdio.h>

int ballx=100,bally=100;
int ballvx=10,ballvy=8;
int px=400;

void bounce() {
    int16_t accel[3];
    MemsConfig();
    vidClearScreen();
    int count=0;
    int maxcount=0;
    char string[16];
    while(1) {
        gdiSetColour(3);
        gdiRectangle(0,0,(VID_HSIZE - 1),VID_VSIZE - 1,0);
        gdiSetColour(2);
        gdiCircle(ballx/16,bally/16,4,0);
        gdiSetColour(7);
        gdiFilledCircle(ballx/16,bally/16,3,0);
      //  gdiCircle(ballx/16,bally/16,2,0);
      //  gdiCircle(ballx/16,bally/16,1,0);
        
        gdiSetColour(4);
        gdiRectangle(px-8,VID_VSIZE-5,px+7,VID_VSIZE-2,0);
        gdiRectangle(px-8,VID_VSIZE-4,px+7,VID_VSIZE-3,0);
        gdiSetColour(7);
        sprintf(string,"Count=%d",count);
        gdiDrawTextEx(4,4,(pu8)string,0);
        sprintf(string,"High=%d",maxcount);
        gdiDrawTextEx(VID_HSIZE-6*strlen(string)-4,4,(pu8)string,0);
               
    //    sysDelayMs(5);
        waitForRefresh();
        vidNextBuffer();
        ReadAccelerometer( accel ); 

        px=(VID_HSIZE/2+accel[1]/100)/8+7*px/8;
        if(px<9) px=9;
        if(px>VID_HSIZE-9) px=VID_HSIZE-9;
        ballx+=ballvx;
        bally+=ballvy;
        if(ballx/16>VID_HSIZE - 6 || ballx<80) {
            ballvx=-ballvx;
            ballx+=ballvx;
        }
        if(bally<80) {
            ballvy=-ballvy;
            bally+=ballvy;
        }
        if(bally/16>VID_VSIZE - 6) {
            if(ballx/16>px-12&&ballx/16<px+12) {
                ballvy=-ballvy-1;
                bally+=ballvy;
                ballvx=ballvx+ballx/16-px;
                count++;
                if(count>maxcount)
                    maxcount=count;
            }
            else {
                bally=100;
                ballvy=10;
                count=0;
            }
        }
        ballvy=ballvy+1;
        if(buttonPress()) return;
    }

}