/***************************************************************************
 * STM32 VGA demo
 * Copyright (C) 2012 Artekit Italy
 * http://www.artekit.eu
 * Written by Ruben H. Meleca
 
### video.h

#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef	__VIDEO_H
#define	__VIDEO_H

#include "gdptypes.h"

#define	VID_HSIZE		196//150 //261		// Horizontal resolution (in bytes)
#define	VID_VSIZE		160//240		// Vertical resolution (in lines)

#define HTOTAL	(VID_HSIZE+5)

#define	VID_PIXELS_X	(VID_HSIZE)
#define	VID_PIXELS_Y	VID_VSIZE

//	Function definitions

void	vidInit(void);
void	vidClearScreen(void);
void waitForRefresh(void);
void vidNextBuffer(void);








#endif	// __VIDEO_H


