#ifndef PINOUT_H
#define PINOUT_H

/* NUCLEO - F446RE Pinout ------------------------------------------------------

SD_CLK          - x x - SD_MISO                 CAN_ENABLE      - x x - XSENS_PING
SD_MOSI         - x x - SD_CS                   CAN_RD          - x x - STEER_SW1
NC              - x x - E5V                     CAN_TD          - x x - STEER_SW2
NC              - x x - GND                     NC              - x x - NC
NC              - x x - NC                      GND             - x x - NC
NC              - x x - NC                      BUCK4           - x x - STEER_SW3
LED3            - x x - RESET                   BUCK3           - x x - STEER_THROTTLE
LED2            - x x - 3V3                     BUCK2           - x x - BIEM_CS1
LED1            - x x - 5V                      LED5            - x x - NC
GND             - x x - GND                     LED4            - x x - GND
FONA_KEY (hack) - x x - GND                     XSENS_RX        - x x - BIEM_CS3
PUSH_GREEN      - x x - NC                      SCRN_LED2       - x x - BIEM_CS2
NC(old PUSH_RED)- x x - NC                      SCRN_LED3       - x x - SPI_MOSI
NC(old FONA_RTS)- x x - FONA_RX                 SCRN_CS3        - x x - SPI_MISO
FONA_RTS(old FONA_RI)- x x - FONA_TX            SCRN_CS2        - x x - SPI_CLK
FONA_NS         - x x - FONA_PS                 SCRN_CS1        - x x - NC
FONA_BAT        - x x - SCRN_LED4               XSENS_TX        - x x - SCRN_DC
BUCK5           - x x - SCRN_LED1               USB_TX          - x x - NC
DEADMAN         - x x - SCRN_RSTD               USB_RX          - x x - NC

------------------------------------------------------------------------------*/

// onboard stuff
#define LED1            PA_15
#define LED2            PA_14
#define LED3            PA_13
#define LED4            PC_7
#define LED5            PB_6

#define BUCK1           /* always enabled */
#define BUCK2           PA_7
#define BUCK3           PA_6
#define BUCK4           PA_5
#define BUCK5           PC_2

#define PUSH_GREEN      PC_13 
#define PUSH_RED        

#define DEADMAN         PC_3

#define SPI_CLK         PB_13
#define SPI_MISO        PB_14
#define SPI_MOSI        PB_15


// SD Card
#define SD_CLK          PC_10
#define SD_MISO         PC_11
#define SD_MOSI         PC_12

#define SD_CS           PD_2


// CAN
#define CAN_RD          PB_8
#define CAN_TD          PB_9

#define CAN_ENABLE      PC_9


// FONA808
#define FONA_RX         PA_0
#define FONA_TX         PA_1

#define FONA_RTS        PH_0
#define FONA_RI         PH_1
#define FONA_NS         PH_1
#define FONA_PS         PA_4
#define FONA_KEY        PB_7

#define FONA_BAT        ADC_VBAT


// XSENS
#define XSENS_RX        PA_9
#define XSENS_TX        PA_10

#define XSENS_PING      PC_8


// BIEM
#define BIEM_CS1        PB_12
#define BIEM_CS2        PB_1
#define BIEM_CS3        PB_2


// Dashboard (Screen)
#define SCRN_LED1       PC_1
#define SCRN_LED2       PA_8
#define SCRN_LED3       PB_10
#define SCRN_LED4       PB_0

#define SCRN_CS1        PB_3
#define SCRN_CS2        PB_5
#define SCRN_CS3        PB_4

#define SCRN_RSTD       PC_0
#define SCRN_DC         PC_4


// Steering wheel
#define STEER_THROTTLE  PC_5

#define STEER_FLY       PC_6
#define STEER_REV       PA_12
#define STEER_MENU      PA_11


// Others
#define TEMP            ADC_TEMP
#define REFERENCE       ADC_VREF



#endif //PINOUT_H