#include "oled_characters.h"    //all OLED chars + logos

#define PI 3.141592
#define SPI_FREQUENCY 5000000

//digital outputs and SPI
SPI spi(PB_15, NC, PB_13);     // mosi, miso, sclk
DigitalOut RST(PB_12);         //reset                             0: reset        1: normal operation
DigitalOut DC(PA_10);          //set input as data or command      0: command      1: data

DigitalOut battery_temp_alert_led(PC_1);
DigitalOut motor_temp_alert_led(PA_8);
DigitalOut battery_low_alert_led(PB_10);
DigitalOut fly_ready_led(PB_0);

DigitalOut CS_1(PB_3);        //chipSelect                        0: selected     1: not selected
DigitalOut CS_2(PB_5);        //chipSelect                        0: selected     1: not selected
DigitalOut CS_3(PB_4);        //chipSelect                        0: selected     1: not selected

bool error_alert;                           //internal error booleaan

bool motor_temp_alert = true;               //LED1                      E01         motor temperature too high
bool battery_temp_alert = true;             //LED2                      E02         battery temperature too high
bool battery_low_alert = true;              //LED3                      E03         battery low power alert
bool fly_ready_alert = true;                //LED4                      E04         ready for flying
bool voltage_in_low = true;                 //DISPLAY                   E05         solar panel voltage is low
bool communication_not_working = true;      //DISPLAY                   E06         communication (FONA) not working
bool dummy_1 = true;                        //DISPLAY                   E07         descr.
bool dummy_2 = true;                        //DISPLAY                   E08         descr.
bool dummy_3 = true;                        //DISPLAY                   E09         descr.
bool dummy_4 = true;                        //DISPLAY                   E10         descr.
bool dummy_5 = true;                        //DISPLAY                   E11         descr.
bool dummy_6 = true;                        //DISPLAY                   E12         descr.
bool dummy_7 = true;                        //DISPLAY                   E13         descr.
bool dummy_8 = true;                        //DISPLAY                   E14         descr.

void drawPixel(int screen_number, uint8_t row, uint8_t col, uint8_t brightness);
void writeNumber(int screen_number, int input_number, char row, char col, int digits, bool large);
void writeLetter(int screen_number, char input, int row, int col);
void drawBitmap(int screen_number, int number, char row, char col, int width, int height);
void updateBatteryBar(int screen_number, int percentage, int row, int col, int width, int height);
void clearDisplay(int screen_number);

void command(int screen_number, uint8_t c)
{
    CS_1 = 1;
    CS_2 = 1;
    CS_3 = 1;

    DC = 0;

    if (screen_number == 1) CS_1 = 0;
    else if (screen_number == 2) CS_2 = 0;
    else if (screen_number == 3) CS_3 = 0;

    spi.write(c);

    CS_1 = 1;
    CS_2 = 1;
    CS_3 = 1;
};

void data(int screen_number, uint8_t c)
{
    CS_1 = 1;
    CS_2 = 1;
    CS_3 = 1;

    DC = 1;

    if (screen_number == 1) CS_1 = 0;
    else if (screen_number == 2) CS_2 = 0;
    else if (screen_number == 3) CS_3 = 0;

    spi.write(c);

    CS_1 = 1;
    CS_2 = 1;
    CS_3 = 1;
};

void powerOnOLED(int screen_number)
{
    if (screen_number == 2) spi.format(8,0);       //SQUARE
    else spi.format(8,3);                          //CIRCULAR
    spi.frequency(SPI_FREQUENCY);

    //internal Vdd regulator on
    command(1, 0xAB);
    command(1, 0x01);
    command(3, 0xAB);
    command(3, 0x01);

    //give reset
    wait(0.1);
    RST = 0;
    wait(0.1);
    RST = 1;

    //display on, normal mode
    command(1, 0xAF);
    command(1, 0xA4);
    command(2, 0xAF);
    command(2, 0xA4);
    command(3, 0xAF);
    command(3, 0xA4);

    //Enable COM remap
    command(1, 0xA0);
    command(1, 0b01000000);
    command(2, 0xA0);
    command(2, 0b01000011);
    command(3, 0xA0);
    command(3, 0b01000000);
}

void welcomeScreen()
{
    //dickbutt
    drawBitmap(1, 75, 5, 5, 50, 100);
    drawBitmap(3, 75, 5, 5, 50, 100);
    //solar boat logo
    drawBitmap(2, 74, 10, 0, 64, 64);
    wait(0.05);
    writeLetter(2, 'S', 12, 60);
    wait(0.05);
    writeLetter(2, 'o', 12, 56);
    wait(0.05);
    writeLetter(2, 'l', 12, 52);
    wait(0.05);
    writeLetter(2, 'a', 12, 48);
    wait(0.05);
    writeLetter(2, 'r', 12, 44);
    wait(0.05);
    writeLetter(2, 'B', 12, 38);
    wait(0.05);
    writeLetter(2, 'o', 12, 34);
    wait(0.05);
    writeLetter(2, 'a', 12, 30);
    wait(0.05);
    writeLetter(2, 't', 12, 26);
    wait(0.05);
    writeLetter(2, 'T', 12, 20);
    wait(0.05);
    writeLetter(2, 'w', 12, 16);
    wait(0.05);
    writeLetter(2, 'e', 12, 12);
    wait(0.05);
    writeLetter(2, 'n', 12, 8);
    wait(0.05);
    writeLetter(2, 't', 12, 4);
    wait(0.05);
    writeLetter(2, 'e', 12, 0);
    wait(0.05);

    clearDisplay(1);
    clearDisplay(2);
    clearDisplay(3);

    //LEDs standard on (1)
    motor_temp_alert_led = 1;
    battery_temp_alert_led = 1;
    battery_low_alert_led = 1;
    fly_ready_led = 1;
}

void resetOLED()
{
    wait(0.1);
    RST = 0;
    wait(0.1);
    RST = 1;
}

void displayData1(int rpm_motor, int battery_temperature, int motor_temperature, int voltage_in, int power_out, int power_in)
{
    if (rpm_motor < 1) rpm_motor = 0;
    if (battery_temperature < 1) battery_temperature = 0;
    if (motor_temperature < 1) motor_temperature = 0;
    if (voltage_in < 1) voltage_in = 0;
    if (power_in < 1) power_in = 0;
    if (power_out < 1) power_out = 0;

    writeLetter(2, 'P', 66, 59);
    writeLetter(2, 'i', 66, 55);
    writeLetter(2, 'n', 66, 51);
    writeLetter(2, ':', 66, 47);

    writeNumber(2, power_in, 66, 13, 5, false);
    writeLetter(2, 'W', 66, 0);

    writeLetter(2, 'P', 56, 59);
    writeLetter(2, 'o', 56, 55);
    writeLetter(2, 'u', 56, 51);
    writeLetter(2, 't', 56, 47);
    writeLetter(2, ':', 56, 43);

    writeNumber(2, power_out, 56, 13, 5, false);
    writeLetter(2, 'W', 56, 0);

    writeLetter(2, 'V', 46, 59);
    writeLetter(2, 'i', 46, 55);
    writeLetter(2, 'n', 46, 51);
    writeLetter(2, ':', 46, 47);

    writeNumber(2, voltage_in, 46, 13, 5, false);
    writeLetter(2, 'm', 46, 4);
    writeLetter(2, 'V', 46, 0);

    writeLetter(2, 'T', 36, 59);
    writeLetter(2, 'm', 36, 55);
    writeLetter(2, 'o', 36, 51);
    writeLetter(2, 't', 36, 47);
    writeLetter(2, ':', 36, 43);

    writeNumber(2, motor_temperature, 36, 13, 3, false);
    writeLetter(2, '*', 36, 4);
    writeLetter(2, 'C', 36, 0);

    writeLetter(2, 'T', 26, 59);
    writeLetter(2, 'b', 26, 55);
    writeLetter(2, 'a', 26, 51);
    writeLetter(2, 't', 26, 47);
    writeLetter(2, ':', 26, 43);

    writeNumber(2, battery_temperature, 26, 13, 3, false);
    writeLetter(2, '*', 26, 4);
    writeLetter(2, 'C', 26, 0);

    writeLetter(2, 'N', 16, 59);
    writeLetter(2, 'm', 16, 55);
    writeLetter(2, 'o', 16, 51);
    writeLetter(2, 't', 16, 47);
    writeLetter(2, ':', 16, 43);

    writeNumber(2, rpm_motor, 16, 13, 4, false);
    writeLetter(2, 'r', 16, 8);
    writeLetter(2, 'p', 16, 4);
    writeLetter(2, 'm', 16, 0);
}

void displayData2(int battery_voltage, int battery_temperature, int motor_temperature, int voltage_in, int power_out, int power_in)
{
    if (battery_voltage < 1) battery_voltage = 0;

    writeLetter(2, 'V', 66, 59);
    writeLetter(2, 'b', 66, 55);
    writeLetter(2, 'a', 66, 51);
    writeLetter(2, 't', 66, 47);
    writeLetter(2, ':', 66, 43);

    writeNumber(2, battery_voltage, 66, 13, 5, false);
    writeLetter(2, 'm', 66, 4);
    writeLetter(2, 'V', 66, 0);

}

void checkForErrors(int current_menu, int velocity, int battery_temperature, int motor_temperature, int MAX_TEMP_MOTOR, int MAX_TEMP_BATTERY, int battery_percentage_left, int battery_minutes_left, int BATTERY_LOW_ALERT)
{
    int amount_of_errors = 0;

    //------------------------------CONDITIONS FOR ERRORS----------------------------------------------
    //errors on LEDs (4x), also display in error overview, last LED end of function
    if (battery_temperature > MAX_TEMP_BATTERY) battery_temp_alert = true;                                                  //battery temperature too high LED
    else battery_temp_alert = false;
    if (motor_temperature > MAX_TEMP_MOTOR) motor_temp_alert = true;                                                        //motor temperature too high LED
    else motor_temp_alert = false;
    if (battery_percentage_left <= BATTERY_LOW_ALERT || battery_minutes_left <= BATTERY_LOW_ALERT) battery_low_alert = true;//battery low LED
    else battery_low_alert = false;
    if (velocity > 20) fly_ready_alert = true;                                                                           //Errors exist LED
    else fly_ready_alert = false;
    //------------------------------END CONDITIONS FOR ERRORS-----------------------------------------

    //------------------------------REACTIONS FOR ERRORS----------------------------------------------
    //set essential LEDs for significant errors
    if (motor_temp_alert) motor_temp_alert_led = 1;
    else motor_temp_alert_led = 0;
    if (battery_temp_alert) battery_temp_alert_led = 1;
    else battery_temp_alert_led = 0;
    if (battery_low_alert) battery_low_alert_led = 1;
    else battery_low_alert_led = 0;
    if (fly_ready_alert) fly_ready_led = 1;
    else fly_ready_led = 0;
    //------------------------------END REACTIONS FOR ERRORS-----------------------------------------

    //count errors for main screen
    if (current_menu == 0) {
        if (motor_temp_alert) amount_of_errors++;
        if (battery_temp_alert) amount_of_errors++;
        if (battery_low_alert) amount_of_errors++;
    }
    /*
    //if in error screen display ALL errors
    if (current_menu == 1) {
        writeLetter(2, 'E', 66, 59);
        writeLetter(2, 'r', 66, 55);
        writeLetter(2, 'r', 66, 51);
        writeLetter(2, 'o', 66, 47);
        writeLetter(2, 'r', 66, 43);
        writeLetter(2, 's', 66, 39);
        writeLetter(2, ':', 66, 35);

        if (motor_temp_alert) {
            writeLetter(2, 'E', 57 - (10*amount_of_errors), 59);
            writeNumber(2, 1, 57 - (10*amount_of_errors), 55, 1, false);
            amount_of_errors++;
        }
        if (battery_temp_alert) {
            writeLetter(2, 'E', 57 - (10*amount_of_errors), 59);
            writeNumber(2, 2, 57 - (10*amount_of_errors), 55, 1, false);
            amount_of_errors++;
        }
        if (battery_low_alert) {
            writeLetter(2, 'E', 57 - (10*amount_of_errors), 59);
            writeNumber(2, 3, 57 - (10*amount_of_errors), 55, 1, false);
            amount_of_errors++;
        }
        //if (error_alert) {
    //            writeLetter(2, 'E', 57 - (10*amount_of_errors), 59);
    //            writeNumber(2, 4, 57 - (10*amount_of_errors), 55, 1, false);
    //            amount_of_errors++;
    //        }

        for (int j = amount_of_errors; j <= 25; j++) {
            if (j < 6) {
                writeLetter(2, ' ', 57 - (10*j), 59);
                writeLetter(2, ' ', 57 - (10*j), 55);
            }
            //else if (j > 5 && j < 11) writeLetter(2, ' ', 64 - (10*(j-5)), 47);
    //        else if (j > 10 && j < 16) writeLetter(2, ' ', 64 - (10*(j-10)), 35);
    //        else if (j > 15 && j < 21) writeLetter(2, ' ', 64 - (10*(j-15)), 23);
    //        else if (j > 20 && j < 26) writeLetter(2, ' ', 64 - (10*(j-20)), 11);
        }

        if (amount_of_errors < 1) {
            amount_of_errors = 0;
            error_alert = false;
        } else error_alert = true;
        if (amount_of_errors < 25) writeLetter(2, ' ', 66, 0);
        else if (amount_of_errors > 25) {
            amount_of_errors = 25;
            writeLetter(2, '+', 66, 0);
        }
        writeNumber(2, amount_of_errors, 66, 4, 2, false);
    }
    if (current_menu == 0 && error_alert) {
        //draw alert logo if errors
        drawBitmap(2, 91, 64, 48, 7, 10);
    } else if (current_menu == 0 && !error_alert) {
        //clear if no errors
        drawBitmap(2, 92, 64, 48, 7, 10);
    } */
}

void showBatteryMinutesLeft(int battery_minutes_left)
{
    if (battery_minutes_left < 1) battery_minutes_left = 0;
    //show minutes left
    writeNumber(3, battery_minutes_left, 55, 20, 3, true);

    writeLetter(3, 'm', 60, 13);
    writeLetter(3, 'i', 60, 9);
    writeLetter(3, 'n', 60, 5);
}

void showBatteryPercentageLeft(int battery_percentage_left)
{
    if (battery_percentage_left > 99) battery_percentage_left = 100;
    else if (battery_percentage_left < 0) battery_percentage_left = 0;

    //show percentage left
    writeNumber(3, battery_percentage_left, 85, 20, 3, true);

    //drawBitmap(1, 91, 85, 10, 10, 20);
    writeLetter(3, '%', 90, 13);

    //show battery logo
    for (int i = 18; i <= 35; i++) {
        drawPixel(3, i, 18, 0x0F);
    }
    for (int i = 18; i <= 35; i++) {
        drawPixel(3, i, 45, 0xF0);
    }
    for (int i = 18; i <= 45; i++) {
        drawPixel(3, 18, i, 0xFF);
    }
    for (int i = 18; i <= 45; i++) {
        drawPixel(3, 36, i, 0xFF);
    }
    for (int i = 22; i <= 31; i++) {
        drawPixel(3, i, 16, 0xF0);
    }
    drawPixel(3, 22, 17, 0xFF);
    drawPixel(3, 31, 17, 0xFF);

    //drawBitmap(1, 75, 15, 20, 30, 24);
    updateBatteryBar(3, battery_percentage_left, 20, 18, 26, 15);
}

void showRaceMinutesDone(int race_minutes_done)
{
    if (race_minutes_done < 1) race_minutes_done = 0;
    //show minutes left
    writeNumber(1, race_minutes_done, 85, 20, 3, true);

    writeLetter(1, 'm', 90, 13);
    writeLetter(1, 'i', 90, 9);
    writeLetter(1, 'n', 90, 5);
}

void showRaceMinutesLeft(int race_minutes_left)
{
    if (race_minutes_left < 1) race_minutes_left = 0;
    //show minutes left
    writeNumber(1, race_minutes_left, 25, 20, 3, true);

    writeLetter(1, 'm', 30, 13);
    writeLetter(1, 'i', 30, 9);
    writeLetter(1, 'n', 30, 5);
}

void showRacePercentageLeft(int race_percentage_left)
{
    if (race_percentage_left > 99) race_percentage_left = 100;
    else if (race_percentage_left < 0) race_percentage_left = 0;

    //show percentage left
    writeNumber(1, race_percentage_left, 55, 20, 3, true);
    writeLetter(1, '%', 60, 13);
}

void checkTransmitter(bool transmitting)
{
    if (time(0) % 2 == 0) transmitting = !transmitting;
    if (transmitting) {
        writeLetter(2, 'T', 65, 12);
        writeLetter(2, 'x', 65, 8);
    } else {
        writeLetter(2, ' ', 65, 12);
        writeLetter(2, ' ', 65, 8);
    }
}

void displayTime()
{
    //int seconds = (int) (time(NULL) % 60);
    int minutes = (int) ((time(NULL) / 60) % 60);
    int hours   = (int) ((time(NULL) / (60*60)) % 24);

    drawBitmap(2, hours / 10 % 10, 65, 39, 4, 7);
    drawBitmap(2, hours % 10, 65, 35, 4, 7);
    writeLetter(2, ':', 65, 31);
    drawBitmap(2, minutes / 10 % 10, 65, 27, 4, 7);
    drawBitmap(2, minutes % 10, 65, 23, 4, 7);
}

void displayAdvisedThrottle(int advised_throttle_power)
{
//    writeNumber(2, advised_throttle_power, 41, 31, 4, false);
//    writeLetter(2, 'r', 41, 21);
//    writeLetter(2, 'p', 41, 17);
//    writeLetter(2, 'm', 41, 13);
}

void displayThrottle(int throttle_power, bool reverse)
{
    writeNumber(2, throttle_power, 45, 31, 4, false);
    writeLetter(2, 'r', 45, 21);
    writeLetter(2, 'p', 45, 17);
    writeLetter(2, 'm', 45, 13);

    if (reverse) {
        writeLetter(2, 'R', 15, 31);
        //blink box around R
        if (time(0) % 2 == 0) {
            for (int i = 12; i < 25; i++) {
                drawPixel(2, i, 30, 0xF0);
            }
            for (int i = 12; i < 25; i++) {
                drawPixel(2, i, 35, 0xF0);
            }
            for (int i = 31; i <= 35; i++) {
                drawPixel(2, 12, i, 0xFF);
            }
            for (int i = 31; i <= 35; i++) {
                drawPixel(2, 24, i, 0xFF);
            }
        } else {
            for (int i = 12; i < 25; i++) {
                drawPixel(2, i, 30, 0x00);
            }
            for (int i = 12; i < 25; i++) {
                drawPixel(2, i, 35, 0x00);
            }
            for (int i = 31; i <= 35; i++) {
                drawPixel(2, 12, i, 0x00);
            }
            for (int i = 31; i <= 35; i++) {
                drawPixel(2, 24, i, 0x00);
            }
        }
    }

    else {
        for (int i = 12; i < 25; i++) {
            drawPixel(2, i, 30, 0xF0);
        }
        for (int i = 12; i < 25; i++) {
            drawPixel(2, i, 35, 0xF0);
        }
        for (int i = 31; i <= 35; i++) {
            drawPixel(2, 12, i, 0xFF);
        }
        for (int i = 31; i <= 35; i++) {
            drawPixel(2, 24, i, 0xFF);
        }
        writeLetter(2, 'D', 15, 31);
    }
}
void displayVelocity(int velocity)
{
    if (velocity < 1) velocity = 0;

    writeNumber(2, velocity, 35, 31, 3, false);
    writeLetter(2, 'k', 35, 21);
    writeLetter(2, 'm', 35, 17);
    writeLetter(2, '/', 35, 13);
    writeLetter(2, 'h', 35, 9);
}

void writeLetter(int screen_number, char input, int row, int col)
{
    int index_ = 63;
    if (input == 'a') index_ = 10;
    if (input == 'b') index_ = 11;
    if (input == 'c') index_ = 12;
    if (input == 'd') index_ = 13;
    if (input == 'e') index_ = 14;
    if (input == 'f') index_ = 15;
    if (input == 'g') index_ = 16;
    if (input == 'h') index_ = 17;
    if (input == 'i') index_ = 18;
    if (input == 'j') index_ = 19;
    if (input == 'k') index_ = 20;
    if (input == 'l') index_ = 21;
    if (input == 'm') index_ = 22;
    if (input == 'n') index_ = 23;
    if (input == 'o') index_ = 24;
    if (input == 'p') index_ = 25;
    if (input == 'q') index_ = 26;
    if (input == 'r') index_ = 27;
    if (input == 's') index_ = 28;
    if (input == 't') index_ = 29;
    if (input == 'u') index_ = 30;
    if (input == 'v') index_ = 31;
    if (input == 'w') index_ = 32;
    if (input == 'x') index_ = 33;
    if (input == 'y') index_ = 34;
    if (input == 'z') index_ = 35;
    if (input == 'A') index_ = 36;
    if (input == 'B') index_ = 37;
    if (input == 'C') index_ = 38;
    if (input == 'D') index_ = 39;
    if (input == 'E') index_ = 40;
    if (input == 'F') index_ = 41;
    if (input == 'G') index_ = 42;
    if (input == 'H') index_ = 43;
    if (input == 'I') index_ = 44;
    if (input == 'J') index_ = 45;
    if (input == 'K') index_ = 46;
    if (input == 'L') index_ = 47;
    if (input == 'M') index_ = 48;
    if (input == 'N') index_ = 49;
    if (input == 'O') index_ = 50;
    if (input == 'P') index_ = 51;
    if (input == 'Q') index_ = 52;
    if (input == 'R') index_ = 53;
    if (input == 'S') index_ = 54;
    if (input == 'T') index_ = 55;
    if (input == 'U') index_ = 56;
    if (input == 'V') index_ = 57;
    if (input == 'W') index_ = 58;
    if (input == 'X') index_ = 59;
    if (input == 'Y') index_ = 60;
    if (input == 'Z') index_ = 61;
    if (input == ';') index_ = 62;
    if (input == '-') index_ = 63;
    if (input == ':') index_ = 64;
    if (input == '+') index_ = 65;
    if (input == '/') index_ = 66;
    if (input == '%') index_ = 67;
    if (input == '?') index_ = 68;
    if (input == ',') index_ = 69;
    if (input == '(') index_ = 70;
    if (input == ')') index_ = 71;
    if (input == '.') index_ = 72;
    if (input == ' ') index_ = 73;
    //logos
    if (input == '*') index_ = 76;

    drawBitmap(screen_number, index_, row, col, 4, 7);
}

void writeNumber(int screen_number, int input_number, char row, char col, int digits, bool large)
{
    unsigned int number_of_digits = 0;
    int counter = input_number;

    do {
        ++number_of_digits;
        counter /= 10;
    } while (counter);

    for (int i = 0; i < number_of_digits; i++) {
        int result = (int) pow((double) 10,i);
        if (large) drawBitmap(screen_number, 80 + (input_number / (result) % 10), row, col + (11*i), 10, 20);
        else drawBitmap(screen_number, input_number / (result) % 10, row, col + (4*i), 4, 7);
    }
    for (int i = number_of_digits; i < digits; i++) {
        if (large) drawBitmap(screen_number, 90, row, col + (11*i), 10, 20);
        else writeLetter(screen_number, ' ', row, col + (4*i));
    }
}

void drawPixel(int screen_number, uint8_t row, uint8_t col, uint8_t brightness)
{
    command(screen_number, 0x15);
    command(screen_number, col);
    command(screen_number, col);

    command(screen_number, 0x75);
    command(screen_number, row);
    command(screen_number, row);

    data(screen_number, brightness);
}

void clearDisplay(int screen_number)
{
    command(screen_number, 0x15);
    command(screen_number, 0x00);
    command(screen_number, 0xFF);

    command(screen_number, 0x75);
    command(screen_number, 0x00);
    command(screen_number, 0xFF);

    if (screen_number == 2) {
        for (int i = 0; i < (128*64); i++) {
            data(screen_number, 0x00);
        }
    } else {
        for (int i = 0; i < (128*128); i++) {
            data(screen_number, 0x00);
        }
    }
}

void updateProgressCircle(int screen_number, int percentage)
{
    //circular battery percentage bar
    int radius = 31;
    for (double theta = 0; theta <= 0.01*percentage*2*PI; theta += 0.01) {
        drawPixel(screen_number, (64+2*radius*(cos(theta))), (32+radius*(sin(theta))), 0xFF);
    }
    for (double theta = 0.01*percentage*2*PI; theta <= 2*PI ; theta += 0.01) {
        drawPixel(screen_number, (64+2*radius*(cos(theta))), (32+radius*(sin(theta))), 0x00);
    }
}

void updatePowerBars(int power_out, int power_in, int MAX_POWER_OUT, int MAX_POWER_IN)
{
    if (power_in < 1) power_in = 0;
    else if (power_in > MAX_POWER_IN) power_in = MAX_POWER_IN;
    if (power_out < 1) power_out = 0;
    else if (power_out > MAX_POWER_OUT) power_out = MAX_POWER_OUT;

    //draw Powerbars
    for (int i = 12; i < 74; i++) {
        drawPixel(2, i, 0, 0x0F);
    }
    for (int i = 12; i < 74; i++) {
        drawPixel(2, i, 4, 0xF0);
    }
    for (int i = 0; i <= 4; i++) {
        drawPixel(2, 12, i, 0xFF);
    }
    for (int i = 0; i <= 4; i++) {
        drawPixel(2, 73, i, 0xFF);
    }
    for (int i = 12; i < 74; i++) {
        drawPixel(2, i, 59, 0x0F);
    }
    for (int i = 12; i < 74; i++) {
        drawPixel(2, i, 63, 0xF0);
    }
    for (int i = 59; i <= 63; i++) {
        drawPixel(2, 12, i, 0xFF);
    }
    for (int i = 59; i <= 63; i++) {
        drawPixel(2, 73, i, 0xFF);
    }

//    writeLetter(2 , 'P', 12, 55);
//    writeLetter(2 , 'i', 12, 51);
//    writeLetter(2 , 'n', 12, 47);
//
//    writeLetter(2 , 'P', 12, 17);
//    writeLetter(2 , 'o', 12, 13);
//    writeLetter(2 , 'u', 12, 9);
//    writeLetter(2 , 't', 12, 5);

    writeLetter(2 , 'I', 12, 55);
    writeLetter(2 , 'n', 12, 51);

    writeLetter(2 , 'O', 12, 13);
    writeLetter(2 , 'u', 12, 9);
    writeLetter(2 , 't', 12, 5);

    //left hand side
    for (int i = 0; i < (58*power_in/MAX_POWER_IN); i++) {
        for (int j = 0; j < 3; j++) {
            drawPixel(2, 14 + i, 60 + j, 0xFF);
        }
    }
    for (int i = (58*power_in/MAX_POWER_IN); i <= 58; i++) {
        for (int j = 0; j < 3; j++) {
            drawPixel(2, 14 + i, 60 + j, 0x00);
        }
    }
    //right hand side
    for (int i = 0; i < (58*power_out/MAX_POWER_OUT); i++) {
        for (int j = 0; j < 3; j++) {
            drawPixel(2, 14 + i, 1 + j, 0xFF);
        }
    }
    for (int i = (58*power_out/MAX_POWER_OUT); i <= 58; i++) {
        for (int j = 0; j < 3; j++) {
            drawPixel(2, 14 + i, 1 + j, 0x00);
        }
    }
}

void updateBatteryBar(int screen_number, int percentage, int row, int col, int width, int height)
{
    for (int i = 0; i < (percentage*width/100); i++) {
        for (int j = 0; j < height; j++) {
            drawPixel(screen_number, row + j, width + col - i, 0xFF);
        }
    }
    for (int i = (percentage*width/100); i < width; i++) {
        for (int j = 0; j < height; j++) {
            drawPixel(screen_number, row + j, width + col - i, 0x00);
        }
    }
}

void drawBitmap(int screen_number, int index_number, char row, char col, int width, int height)
{
    command(screen_number, 0x15);
    command(screen_number, col);
    command(screen_number, (col + (width-1)));

    command(screen_number, 0x75);
    command(screen_number, row);
    command(screen_number, (row + (height-1)));

    for(int i = (width*height-1); i >= 0; i--) {

        switch (index_number) {

            case 0:
                data(screen_number, number_0_small[i]);
                break;
            case 1:
                data(screen_number, number_1_small[i]);
                break;
            case 2:
                data(screen_number, number_2_small[i]);
                break;
            case 3:
                data(screen_number, number_3_small[i]);
                break;
            case 4:
                data(screen_number, number_4_small[i]);
                break;
            case 5:
                data(screen_number, number_5_small[i]);
                break;
            case 6:
                data(screen_number, number_6_small[i]);
                break;
            case 7:
                data(screen_number, number_7_small[i]);
                break;
            case 8:
                data(screen_number, number_8_small[i]);
                break;
            case 9:
                data(screen_number, number_9_small[i]);
                break;
            case 10:
                data(screen_number, letter_a_small[i]);
                break;
            case 11:
                data(screen_number, letter_b_small[i]);
                break;
            case 12:
                data(screen_number, letter_c_small[i]);
                break;
            case 13:
                data(screen_number, letter_d_small[i]);
                break;
            case 14:
                data(screen_number, letter_e_small[i]);
                break;
            case 15:
                data(screen_number, letter_f_small[i]);
                break;
            case 16:
                data(screen_number, letter_g_small[i]);
                break;
            case 17:
                data(screen_number, letter_h_small[i]);
                break;
            case 18:
                data(screen_number, letter_i_small[i]);
                break;
            case 19:
                data(screen_number, letter_j_small[i]);
                break;
            case 20:
                data(screen_number, letter_k_small[i]);
                break;
            case 21:
                data(screen_number, letter_l_small[i]);
                break;
            case 22:
                data(screen_number, letter_m_small[i]);
                break;
            case 23:
                data(screen_number, letter_n_small[i]);
                break;
            case 24:
                data(screen_number, letter_o_small[i]);
                break;
            case 25:
                data(screen_number, letter_p_small[i]);
                break;
            case 26:
                data(screen_number, letter_q_small[i]);
                break;
            case 27:
                data(screen_number, letter_r_small[i]);
                break;
            case 28:
                data(screen_number, letter_s_small[i]);
                break;
            case 29:
                data(screen_number, letter_t_small[i]);
                break;
            case 30:
                data(screen_number, letter_u_small[i]);
                break;
            case 31:
                data(screen_number, letter_v_small[i]);
                break;
            case 32:
                data(screen_number, letter_w_small[i]);
                break;
            case 33:
                data(screen_number, letter_x_small[i]);
                break;
            case 34:
                data(screen_number, letter_y_small[i]);
                break;
            case 35:
                data(screen_number, letter_z_small[i]);
                break;
            case 36:
                data(screen_number, letter_a_large[i]);
                break;
            case 37:
                data(screen_number, letter_b_large[i]);
                break;
            case 38:
                data(screen_number, letter_c_large[i]);
                break;
            case 39:
                data(screen_number, letter_d_large[i]);
                break;
            case 40:
                data(screen_number, letter_e_large[i]);
                break;
            case 41:
                data(screen_number, letter_f_large[i]);
                break;
            case 42:
                data(screen_number, letter_g_large[i]);
                break;
            case 43:
                data(screen_number, letter_h_large[i]);
                break;
            case 44:
                data(screen_number, letter_i_large[i]);
                break;
            case 45:
                data(screen_number, letter_j_large[i]);
                break;
            case 46:
                data(screen_number, letter_k_large[i]);
                break;
            case 47:
                data(screen_number, letter_l_large[i]);
                break;
            case 48:
                data(screen_number, letter_m_large[i]);
                break;
            case 49:
                data(screen_number, letter_n_large[i]);
                break;
            case 50:
                data(screen_number, letter_o_large[i]);
                break;
            case 51:
                data(screen_number, letter_p_large[i]);
                break;
            case 52:
                data(screen_number, letter_q_large[i]);
                break;
            case 53:
                data(screen_number, letter_r_large[i]);
                break;
            case 54:
                data(screen_number, letter_s_large[i]);
                break;
            case 55:
                data(screen_number, letter_t_large[i]);
                break;
            case 56:
                data(screen_number, letter_u_large[i]);
                break;
            case 57:
                data(screen_number, letter_v_large[i]);
                break;
            case 58:
                data(screen_number, letter_w_large[i]);
                break;
            case 59:
                data(screen_number, letter_x_large[i]);
                break;
            case 60:
                data(screen_number, letter_y_large[i]);
                break;
            case 61:
                data(screen_number, letter_z_large[i]);
                break;
            case 62:
                data(screen_number, letter_semicolon[i]);
                break;
            case 63:
                data(screen_number, letter_minus[i]);
                break;
            case 64:
                data(screen_number, letter_dubbelepunt[i]);
                break;
            case 65:
                data(screen_number, letter_plus[i]);
                break;
            case 66:
                data(screen_number, letter_slash[i]);
                break;
            case 67:
                data(screen_number, letter_percent[i]);
                break;
            case 68:
                data(screen_number, letter_questionmark[i]);
                break;
            case 69:
                data(screen_number, letter_comma[i]);
                break;
            case 70:
                data(screen_number, letter_open[i]);
                break;
            case 71:
                data(screen_number, letter_close[i]);
                break;
            case 72:
                data(screen_number, letter_dot[i]);
                break;
            case 73:
                data(screen_number, letter_space[i]);
                break;
            case 74:
                data(screen_number, logo_solar_boat[i]);
                break;
            case 75:
                data(screen_number, logo_dickbutt[i]);
                break;
            case 76:
                data(screen_number, letter_degree[i]);
                break;
                //+80 for large numbers
            case 80:
                data(screen_number, large_0[i]);
                break;
            case 81:
                data(screen_number, large_1[i]);
                break;
            case 82:
                data(screen_number, large_2[i]);
                break;
            case 83:
                data(screen_number, large_3[i]);
                break;
            case 84:
                data(screen_number, large_4[i]);
                break;
            case 85:
                data(screen_number, large_5[i]);
                break;
            case 86:
                data(screen_number, large_6[i]);
                break;
            case 87:
                data(screen_number, large_7[i]);
                break;
            case 88:
                data(screen_number, large_8[i]);
                break;
            case 89:
                data(screen_number, large_9[i]);
                break;
            case 90:
                data(screen_number, large_space[i]);
                break;
            case 91:
                data(screen_number, alert_sign[i]);
                break;
            case 92:
                data(screen_number, alert_sign_space[i]);
                break;
        }
    }
}
