#include "mbed.h"
#include "oled_driver.h"

#define MENU_TIMEOUT_TIME       5.0             //menu timeout in seconds                   [s]
#define MAX_POWER_IN            1500            //max power in for power bars               [W]
#define MAX_POWER_OUT           2000            //max power out for power bars              [W]
#define MAX_TEMP_MOTOR          80              //alert when exceeding temp                 ['C]
#define MAX_TEMP_BATTERY        60              //alert when exceeding temp                 ['C]
#define MAX_REVERSE_VELOCITY    20              //max velocity for allowing reverse         [km/h]
#define MIN_SOLAR_PANEL_VOLTAGE 30              //min voltage provided by solar panels      [V]
#define MIN_FLY_VELOCITY        15              //min velocity to request fly               [km/h]
#define BATTERY_LOW_ALERT       10              //min battery percentage                    [%, min]

DigitalIn menu_button(D0);
DigitalIn fly_button(D0);
DigitalIn reverse_button(D0);
AnalogIn analog_throttle(A0);

//global variables
int battery_percentage_left = 0;
int battery_minutes_left = 0;
int race_percentage_left = 0;
int race_minutes_left = 0;
int race_minutes_done = 0;
int throttle_power = 0;
int advised_throttle_power = 0;
int power_in = 0;
int power_out = 0;
int voltage_in = 0;
int motor_temperature = 0;
int battery_temperature = 0;
int velocity = 0;
int rpm_motor = 0;
int checkIfButtonPressed(int current_menu);
int battery_voltage = 0;
int current_menu = 0;
time_t start = time(0);
void readEssentials();
bool menu_button_pressed = true;
bool reverse_button_pressed = true;
bool fly_request = true;
bool transmitting = false;
bool reverse = false;

int main()
{
    powerOnOLED(1);
    powerOnOLED(2);
    powerOnOLED(3);

    clearDisplay(1);
    clearDisplay(2);
    clearDisplay(3);

    //welcomeScreen();

    while(1) {


        //listen to menu button
        current_menu = checkIfButtonPressed(current_menu);
        //listen to steering wheel at all time
        readEssentials();
        //check for errors at all time
        checkForErrors(current_menu, velocity, battery_temperature, motor_temperature, MAX_TEMP_MOTOR, MAX_TEMP_BATTERY, battery_percentage_left, battery_minutes_left, BATTERY_LOW_ALERT);
        
       
        switch (current_menu) {

            case 0:
                //circular display (1)
                //updateProgressCircle(1, race_percentage_left);
                race_minutes_done = time(0)/60;         //TODO give starting point
                showRaceMinutesDone(race_minutes_done);
                showRaceMinutesLeft(race_minutes_left);
                showRacePercentageLeft(race_percentage_left);

                //main display (2)
                displayTime();
                checkTransmitter(transmitting);
                displayVelocity(velocity);
                displayThrottle(throttle_power, reverse);
                //displayAdvisedThrottle(advised_throttle_power);
                updatePowerBars(power_out, power_in, MAX_POWER_OUT, MAX_POWER_IN);

                //circular display (3)
                //updateProgressCircle(3, battery_percentage_left);
                showBatteryMinutesLeft(battery_minutes_left);
                showBatteryPercentageLeft(battery_percentage_left);
                break;

            case 1:
                //circular display (1)
                //updateProgressCircle(1, race_percentage_left);
                race_minutes_done = time(0)/60;         //TODO give starting point
                showRaceMinutesDone(race_minutes_done);
                showRaceMinutesLeft(race_minutes_left);
                showRacePercentageLeft(race_percentage_left);

                //main display (2)
                displayData1(rpm_motor, battery_temperature, motor_temperature, voltage_in, power_out, power_in);

                //circular display (3)
                //updateProgressCircle(3, battery_percentage_left);
                showBatteryMinutesLeft(battery_minutes_left);
                showBatteryPercentageLeft(battery_percentage_left);
                break;

            case 2:
                //circular display (1)
                //updateProgressCircle(1, race_percentage_left);
                race_minutes_done = time(0)/60;         //TODO give starting point
                showRaceMinutesDone(race_minutes_done);
                showRaceMinutesLeft(race_minutes_left);
                showRacePercentageLeft(race_percentage_left);

                //main display (2)
                displayData2(battery_voltage, battery_temperature, motor_temperature, voltage_in, power_out, power_in);

                //circular display (3)
                //updateProgressCircle(3, battery_percentage_left);
                showBatteryMinutesLeft(battery_minutes_left);
                showBatteryPercentageLeft(battery_percentage_left);
                break;
            default:
                //empty, catch
                break;
        }
    }
}

int checkIfButtonPressed(int current_menu)
{
    //--------------MENU BUTTON--------------------
    if (menu_button == 0 && menu_button_pressed == false) {
        menu_button_pressed = true;
        start = time(0);
        current_menu++;
        if (current_menu > 2) current_menu = 0;
        clearDisplay(1);
        clearDisplay(2);
        clearDisplay(3);
    } else if (menu_button == 1) menu_button_pressed = false;
    //timeout for back to home screen
    double seconds_since_start = difftime(time(0), start);
    if (current_menu != 0 && seconds_since_start > MENU_TIMEOUT_TIME) {
        current_menu = 0;
        clearDisplay(1);
        clearDisplay(2);
        clearDisplay(3);
    }

    //--------------REVERSE BUTTON--------------------
    if (reverse_button == 0 && reverse_button_pressed == false) {
        reverse_button_pressed = true;
        if (velocity < MAX_REVERSE_VELOCITY) reverse = !reverse;
    } else if (reverse_button == 1) reverse_button_pressed = false;

    //--------------FLY BUTTON--------------------
    if (fly_button == 0 && fly_request == false) {
        fly_request = true;
        if (velocity > MIN_FLY_VELOCITY) fly_request = !fly_request;
    } else if (fly_button == 1) fly_request = false;

    //return for menu
    return current_menu;
}

void readEssentials()
{

    //get current throttle set + adjust params  -------- DEBUG
    //throttle_power = 500 - (500*analog_throttle);
    power_out = 580;
    power_in = 680;
    velocity = 0.1*throttle_power;
    battery_minutes_left = throttle_power/6;
    battery_percentage_left = throttle_power/5;
    motor_temperature = 68;
    battery_temperature = 24;
    battery_voltage = 45;
    rpm_motor = 6*throttle_power;
    voltage_in = 44;
    race_minutes_left = 12;
    race_percentage_left = 100*race_minutes_done/(race_minutes_left+race_minutes_done);
}
