#ifndef DASH_H
#include "mbed.h"
#include "pinout.h"
#include "oled_characters.h"    //all OLED chars + logos

#define MENU_TIMEOUT_TIME       5.0             //menu timeout in seconds                   [s]
#define MAX_POWER_IN            1500            //max power in for power bars               [W]
#define MAX_POWER_OUT           2000            //max power out for power bars              [W]
#define MAX_TEMP_MOTOR          80              //alert when exceeding temp                 ['C]
#define MAX_TEMP_BATTERY        60              //alert when exceeding temp                 ['C]
#define MAX_REVERSE_VELOCITY    20              //max velocity for allowing reverse         [km/h]
#define MIN_SOLAR_PANEL_VOLTAGE 30              //min voltage provided by solar panels      [V]
#define MIN_FLY_VELOCITY        15              //min velocity to request fly               [km/h]
#define BATTERY_LOW_ALERT       10              //min battery percentage                    [%, min]

#define PI 3.141592
#define SPI_FREQUENCY 5000000

class Dashboard {
    
    private:

        void drawPixel(int screen_number, uint8_t row, uint8_t col, uint8_t brightness);
        void writeNumber(int screen_number, int input_number, char row, char col, int digits, bool large);
        void writeLetter(int screen_number, char input, int row, int col);
        void drawBitmap(int screen_number, int number, char row, char col, int width, int height);
        void updateBatteryBar(int screen_number, int percentage, int row, int col, int width, int height);        
        
    public:
    
        Dashboard(void);
    
        void clearDisplay(int screen_number);
    
        void command(int screen_number, uint8_t c);

        void data(int screen_number, uint8_t c);

        void powerOnOLED(int screen_number);
        
        void welcomeScreen();

        void resetOLED();
        
        void updateTemperatureBars(int motor_temperature, int battery_temperature);
        
        void updateThrottleBar(int screen_number, int percentage, int row, int col, int width, int height);

        void displayData1(int rpm_motor, int battery_temperature, int motor_temperature, int voltage_in, int power_out, int power_in);

        void displayData2(int battery_voltage, int battery_temperature, int motor_temperature, int voltage_in, int power_out, int power_in);

        void checkForErrors(int current_menu, int velocity, int battery_temperature, int motor_temperature, int battery_percentage_left, int battery_minutes_left);

        void showBatteryMinutesLeft(int battery_minutes_left);

        void showBatteryPercentageLeft(unsigned char battery_percentage_left);

        void showRaceMinutesDone(int race_minutes_done);

        void showRaceMinutesLeft(int race_minutes_left);

        void showRacePercentageLeft(int race_percentage_left);

        void checkTransmitter(bool transmitting);

        void displayTime(long long int time);

        void displayAdvisedThrottle(int advised_throttle_power);

        void displayThrottle(int throttle_power, bool reverse);

        void displayVelocity(int velocity);

        void updateProgressCircle(int screen_number, int percentage);

        void updatePowerBars(int power_out, int power_in);

};


#endif