#include "mbed.h"
#include "MODSERIAL.h"
#include "FastPWM.h"
#include "QEI.h"
#include "math.h"

Serial pc(USBTX,USBRX);

// functies aan PINs toevoegen
DigitalOut led1(D2);
FastPWM led(PTA1);
FastPWM motor1(D6);
DigitalOut motor1_dir(D7);
FastPWM motor2(D5);
DigitalOut motor2_dir(D4);
AnalogIn pot1(PTB2);
AnalogIn pot2(PTB3);
InterruptIn button1(PTB10);
InterruptIn button2(PTB11);

// timer opzetten = ticker
Ticker ticker;

// opzetten van hoekbepaling
QEI encoder(D13,D12,NC,64,QEI::X4_ENCODING); // Pulsesperrevolution=64
QEI encoder_2(D11,D10,NC,64,QEI::X4_ENCODING);

//Global values
int motordir1 = 1;
int motordir2 = 1;
double Kp = 17.5; //proportional gain = tuning parameter

// aparte functies
//functie motor aansturen met pot



void motor_position(double y_des)
{
    
    double y_pos = encoder_2.getPulses();
    double y_poscorrect = y_pos/8400.0;
    double error = y_des-y_poscorrect;
    if (error >=0) motor1_dir=1;
    else motor1_dir=0;
    if (fabs(error)>1) motor1 = 1;
    else motor1 = fabs(error);
}
  

void main_loop()
{   
        double potpos = pot1.read();
        motor_position(potpos);
        
}

int main()
{ 
    motor1_dir.write(motordir1);
    motor2_dir.write(motordir2);
    ticker.attach(&main_loop, 0.001f);
    while(true){
        pc.printf("pot1(%f),enc1 is (%d),pot2(%f),enc2 is (%d)\r\n",pot1.read(),encoder.getPulses(),pot2.read(),encoder_2.getPulses());
        wait(0.1f);
        };  
}