#include "mbed.h"
#include "FirmwareUpdater.h"
#include "MSCFileSystem.h"
#include "TextLCD.h"


FirmwareUpdater fwup("firmware", "firmware", true);
// There are 2 files for the firmware.
//  1. firmware.txt : firmware version file.
//  2. firmware.bin : firmware binary file.
Serial pc(USBTX, USBRX); // tx, rx

//          rs    e    d4   d5   d6   d7
TextLCD lcd(p26, p25, p21, p22, p23, p24, TextLCD::LCD20x4); // rs, e, d4-d7
DigitalOut myled(LED1);

int main() {
    lcd.printf("Start Updateprocess");
    printf("execute update\r ");
    if (fwup.exist() == 0) {
        printf("Found a new firmware.\n\r");
        if (fwup.execute() == 0) {
            printf("Update succeed.\n\r");
            printf("Resetting this system...\n\n\n\n\n\r");
            fwup.reset();
        } else {
            printf("Update failed!\n\r");
        }
    }
    
    while (1) {
        lcd.printf ("Endless loop");
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
    }
}
