#include "mbed.h"
#include "FirmwareUpdater.h"

FirmwareUpdater fwup("firmware", "firmware", true);
// There are 2 files for the firmware.
//  1. firmware.txt : firmware version file.
//  2. firmware.bin : firmware binary file.
Serial pc(USBTX, USBRX); // tx, rx


DigitalOut myled(LED1);

int main() {
    printf("execute update\r ");
    if (fwup.exist() == 0) {
        printf("Found a new firmware.\n\r");
        if (fwup.execute() == 0) {
            printf("Update succeed.\n\r");
            printf("Resetting this system...\n\n\n\n\n\r");
            fwup.reset();
        } else {
            printf("Update failed!\n\r");
        }
    }
    while (1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
