/*******************************************************************************
* This program demonstrates how to drive the RenBuggy_Servo
* using the Car library.
* 
* Mark Jones 
* V1.0 05/03/2014
*******************************************************************************/

#include "mbed.h"
#include "Car.h"

Car myCar(P1_26, P1_24, 16, 16.65f, P0_7);

// Main entry point of application.
int main() {
    
    const int SERVO_PWM = 1500;             // 1500 = centre.
    const int SERVO_PWM_PERIOD = 2000;  
    const int SERVO_PWM_RANGE = 500;        // + or - 500 microseconds.
    const float SERVO_DEGREES_RANGE = 45.0; // + or - from centre is full right/left.
    
    const int MOTOR_PWM = 20000;
    const int MOTOR_PERIOD = 20000;
    
    // Configure the servo and motor before use.
    myCar.configureServo_us(SERVO_PWM, SERVO_PWM_PERIOD, 
    SERVO_PWM_RANGE, SERVO_DEGREES_RANGE);
    
    myCar.configureMotor_us(MOTOR_PWM, MOTOR_PERIOD);
    
    myCar.setDirection(0);
    
    myCar.forwards(7);
    myCar.setDirection(45);
    myCar.forwards(20);
    myCar.setDirection(-30);
    myCar.forwards(20);    
}