/* mbed Microcontroller Library
 * Copyright (c) 2015-2016 Nuvoton
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#include "serial_api.h"


#include "cmsis.h"
#include "mbed_error.h"
#include "mbed_assert.h"
#include "PeripheralPins.h"
#include "nu_modutil.h"
#include "nu_bitutil.h"
#include <string.h>
#include <stdbool.h>

#if DEVICE_SERIAL_ASYNCH
#include "dma_api.h"
#include "dma.h"
#define DbPrintf(...)   sprintf(QStr,__VA_ARGS__);   PutDebMsg(QStr,32) 

#define UART_PARITY_BY_UART_DATTBIT9   (0x11ul << UART_LINE_PBE_Pos) /*!< UART_LINE setting to keep parity bit as '0'  \hideinitializer */


#ifdef __cplusplus
extern "C" {
#endif

void serial_format_9bit(serial_t *obj, int data_bits, SerialParity parity, int stop_bits);
int  serial_tx_asynch9bit(serial_t *obj, const void *tx, size_t tx_length, uint8_t tx_width, uint32_t handler, uint32_t event, DMAUsage hint);
void serial_rx_asynch9bit(serial_t *obj, void *rx, size_t rx_length, uint8_t rx_width, uint32_t handler, uint32_t event, uint8_t char_match, DMAUsage hint);
int serial_irq_handler_asynch9bit(serial_t *obj);
uint16_t serial_getc_9bit(serial_t *obj);
int serial_readable_9bit(serial_t *obj);
void serial_putc_9bit(serial_t *obj, uint16_t c);
extern char uart9debug[100];
extern bool uartdebug;
extern char QStr[64];



#ifdef __cplusplus
}
#endif


#endif
