/* mbed Microcontroller Library
 * Copyright (c) 2015-2016 Nuvoton
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "mbed.h"
#ifndef __NU_UART9BIT_H__
#define __NU_UART9BIT_H__
#if TARGET_NUVOTON


namespace mbed {

class UART9BIT :  public Serial 
{

public:

   UART9BIT(PinName tx, PinName rx, int baud,bool en9bit); 
    
void format(int bits = 9, Parity parity = UART9BIT::None, int stop_bits = 1);
void GetUartName(void);
int GitRxDataLen(void);
int write(const uint16_t *buffer, int length, const event_callback_t &callback, int event = SERIAL_EVENT_TX_COMPLETE);
int read(uint16_t *buffer, int length, const event_callback_t &callback, int event = SERIAL_EVENT_RX_COMPLETE, unsigned char char_match = SERIAL_RESERVED_CHAR_MATCH);
void SetRxDataLen(size_t len);
uint16_t getu16(void);
void putu16(uint16_t data);
int serial_readable(void);

protected:
  bool Enable9Bit;
  void start_read(void *buffer, int buffer_size, char buffer_width, const event_callback_t &callback, int event, unsigned char char_match);
  void start_write(const void *buffer, int buffer_size, char buffer_width, const event_callback_t &callback, int event);
 
  void interrupt_handler_asynch(void);  
  CThunk<UART9BIT> _thunk9_irq;
};

}




#endif  /* TARGET_NUVOTON */
#endif  /* __NU_UART9BIT_H__ */
