#include "mbed.h"
#include "HTU21D.h"
#include "FXOS8700.h"
#include "Hexi_OLED_SSD1351.h"
#include <stdlib.h>    
#include <time.h>
//#include "images.h"
#include "string.h"
#include "math.h"
//#include "Fever_Click.h"
#include "Hexi_KW40Z.h"
#include "hexidraw.h"
//#include "MAX30101.h"
//#include "heartRate_driver.h"
#define LED_ON      0
#define LED_OFF     1
OLED oled1;
DigitalOut redLed(LED1);
DigitalOut greenLed(LED2);
DigitalOut blueLed(LED3);
DigitalOut haptic(PTB9);  
void StartHaptic(void);
void StopHaptic(void const *n);



// Pin connections
//DigitalOut led1(LED_GREEN); // RGB LED
Serial pc(USBTX, USBRX); // Serial interface
HTU21D temphumid(PTB1,PTB0); // HTU21D Sensor
DigitalOut powerEN (PTB12); // Power Enable HTU21D Sensor
FXOS8700 accel(PTC11, PTC10);
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); // SSD1351 OLED Driver (MOSI,SCLK,POWER,CS,RST,DC)
//MAX30101 heart(PTB1, PTB0);
//I2C i2c(PTD9,PTD8);

void ButtonUp(void);
void ButtonDown(void);
void ButtonRight(void);
void ButtonLeft(void);
void ButtonSlide(void);
/* Define timer for haptic feedback */
RtosTimer hapticTimer(StopHaptic, osTimerOnce);

/* Instantiate the Hexi KW40Z Driver (UART TX, UART RX) */ 
KW40Z kw40z_device(PTE24, PTE25);
// Variables
int sample_ftemp,flag=0,ped=0,oldped=0,cal=0,once=0;
int sample_ctemp;
int sample_ktemp;
int sample_humid;
float accel_data[3]; // Storage for the data from the sensor
float accel_rms=0.0; // RMS value from the sensor
float acc=0;
float ax, ay, az;// temp;
char text1[20];
const uint8_t *image1; // Pointer for the image to be displayed
char text[20]; // Text Buffer for dynamic value displayed
uint8_t data;
uint8_t sample= rand() % 5 + 62;
int main() {
    srand (time(NULL));
    powerEN = 0;
    
    /* Setting pointer location of the 96 by 96 pixel bitmap */
    //image1  = TempHumid;

    /* Turn on the backlight of the OLED Display */
    // oled.DimScreenON();
    
    /* Fill 96px by 96px Screen with 96px by 96px NXP Image starting at x=0,y=0 */
   // oled.DrawImage(image1,0,0);  
    oled.TextBox((uint8_t *)text,0,0,96,96); 
    while(true) {

        kw40z_device.attach_buttonUp(&ButtonUp);
        kw40z_device.attach_buttonDown(&ButtonDown);
        kw40z_device.attach_buttonLeft(&ButtonLeft);
        kw40z_device.attach_buttonRight(&ButtonRight);
        kw40z_device.attach_buttonSlide(&ButtonSlide);
        sample_ftemp = temphumid.sample_ftemp()-30;
        printf("Temperature: %d F\n\r", sample_ftemp);

        sample_ctemp = temphumid.sample_ctemp();
        printf("Temperature: %d C\n\r", sample_ctemp);

        sample_ktemp = temphumid.sample_ktemp();
        printf("Temperature: %d K\n\r", sample_ktemp);

        sample_humid = temphumid.sample_humid();
        printf("Humidity: %d %%\n\r", sample_humid);
        printf("\n\r");
        
        accel.acquire_accel_data_g(accel_data);
      accel_rms = sqrt(((accel_data[0]*accel_data[0])+(accel_data[1]*accel_data[1])+(accel_data[2]*accel_data[2]))/3);
      printf("Accelerometer \tX-Axis %4.2f \tY-Axis %4.2f \tZ-Axis %4.2f \tRMS %4.2f\n\r",accel_data[0],accel_data[1],accel_data[2],accel_rms);
      wait(0.01);
      ax = accel_data[0];
      ay = accel_data[1];
      az = accel_data[2];
      
        /* Get OLED Class Default Text Properties */
        
        oled_text_properties_t textProperties = {0};
        oled.GetTextProperties(&textProperties);
        /*
        textProperties.fontColor = COLOR_WHITE;
        textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
        oled.SetTextProperties(&textProperties);  
        strcpy((char *) text,"");
        strcpy((char *) text,"ECE 595");
        oled.Label((uint8_t *)text,0,0);
        strcpy((char *) text," FITNESS MONITOR");
        oled.Label((uint8_t *)text,0,7);
        */
        /* Set text properties to white and right aligned for the dynamic text */
        textProperties.fontColor = COLOR_RED;
        textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
        oled.SetTextProperties(&textProperties);  
      if(sample_ftemp>70 && flag == 0)
        {
            textProperties.fontColor = COLOR_BLUE;
            textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
            oled.SetTextProperties(&textProperties);  
            flag=1;
            strcpy((char *) text,"Cool clothes!");
            oled.Label((uint8_t *)text,15,5);
            // sprintf(text,"%i",sample_ctemp);
            //oled.Label((uint8_t *)text,5,5); 
             
            strcpy((char *) text,"");
            textProperties.fontColor = COLOR_RED;
            textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
            oled.SetTextProperties(&textProperties);  
            strcpy((char *) text,"Temp.");
        
            oled.Label((uint8_t *)text,5,67);      
      
        /* Format the value */
            sprintf(text,"%i",sample_ftemp);
        /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
            oled.TextBox((uint8_t *)text,57,67,20,15); //Increase textbox for more digits
        
        /* Display Units */
            strcpy((char *) text,"dF");
            oled.Label((uint8_t *)text,82,67);     
            wait(5);
            //oled1.clear(BLACK);
            oled.TextBox((uint8_t *)text,0,0,96,96);
        } 
        else if(sample_ftemp<60 && flag == 0)
        {
            textProperties.fontColor = COLOR_RED;
            textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
            oled.SetTextProperties(&textProperties);  
            flag=1;
            strcpy((char *) text,"Warm clothes!");
            oled.Label((uint8_t *)text,15,5);
            // sprintf(text,"%i",sample_ctemp);
            //oled.Label((uint8_t *)text,5,5); 
            
            strcpy((char *) text,"");
            textProperties.fontColor = COLOR_RED;
            textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
            oled.SetTextProperties(&textProperties);  
            strcpy((char *) text,"Temp.");
            oled.Label((uint8_t *)text,5,67);      
      
        /* Format the value */
            sprintf(text,"%i",sample_ftemp);
        /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
            oled.TextBox((uint8_t *)text,57,67,20,15); //Increase textbox for more digits
        
        /* Display Units */
            strcpy((char *) text,"dF");
            oled.Label((uint8_t *)text,82,67);     
            wait(3);
            strcpy((char *) text,"");
            oled.TextBox((uint8_t *)text,0,0,96,96);
        }
        /*
        textProperties.fontColor = COLOR_WHITE;
        textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
        oled.SetTextProperties(&textProperties);  
        strcpy((char *) text,"");
        strcpy((char *) text,"ECE 595");
        oled.Label((uint8_t *)text,0,0);
        strcpy((char *) text," FITNESS MONITOR");
        oled.Label((uint8_t *)text,0,7);
        */
         //oled.TextBox((uint8_t *)text,0,0,96,96);
        /* Display Legends */
            textProperties.fontColor = COLOR_RED;
            textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
            oled.SetTextProperties(&textProperties);  
            strcpy((char *) text,"Temp.");
            oled.Label((uint8_t *)text,5,67);      
      
        /* Format the value */
            sprintf(text,"%i",sample_ftemp);
        /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
            oled.TextBox((uint8_t *)text,57,67,20,15); //Increase textbox for more digits
        
        /* Display Units */
            strcpy((char *) text,"dF");
            oled.Label((uint8_t *)text,82,67);     
      /* Set text properties to white and right aligned for the dynamic text */ 
        textProperties.fontColor = COLOR_BLUE;
        textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
        oled.SetTextProperties(&textProperties);  
      
        /* Display Legends */
        strcpy((char *) text,"Humidity");
        oled.Label((uint8_t *)text,5,81);       
      
        /* Format the value */
        sprintf(text,"%i",sample_humid);
        /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
        oled.TextBox((uint8_t *)text,57,81,20,15); //Increase textbox for more digits
        
        /* Display Units */
        strcpy((char *) text,"%");
        oled.Label((uint8_t *)text,82,81); 
      //pedometer
            textProperties.fontColor = COLOR_GREEN;
            textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
            oled.SetTextProperties(&textProperties);  
            strcpy((char *) text1,"Steps:");
            oled.Label((uint8_t *)text1,3,35);      
            acc=sqrt(pow(ax,2)+pow(ay,2)/2);
            textProperties.fontColor = COLOR_WHITE;
            textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
            oled.SetTextProperties(&textProperties);  
            strcpy((char *) text1,"Calories:");
            oled.Label((uint8_t *)text1,3,50);
      if(acc>0.3){
          wait(0.5);
          ped++;
          if(ped==oldped+36){
              cal++;
              oldped=ped;
          }
      }
      if(ped>25)
      {
        oled_text_properties_t textProperties = {0};
        oled.GetTextProperties(&textProperties);
        //oled1.clear(BLACK);
        //oled.TextBox((uint8_t *)text,0,0,96,96);
        wait(1);
     /* Get OLED Class Default Text Properties */
        //for(int i=0;i<5;i++)
       // {
        
        /* Set text properties to white and right aligned for the dynamic text */
        textProperties.fontColor = COLOR_GREEN;
        textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
        oled.SetTextProperties(&textProperties);  
        strcpy((char *) text,"");
        strcpy((char *) text,"TargetAchieved");
        oled.Label((uint8_t *)text,0,7);
        strcpy((char *) text,"");
        //sprintf(text,"%i", rand() % 5 + 62);
        //oled.Label((uint8_t *)text,70,7);
        //wait(7);
        }
      /* Format the value */
        textProperties.fontColor = COLOR_GREEN;
        textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
        oled.SetTextProperties(&textProperties);  
        sprintf(text1,"%4d",ped);
        oled.TextBox((uint8_t *)text1,70,35,20,15); //Increase textbox for more digits
      /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
        textProperties.fontColor = COLOR_WHITE;
        textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
        oled.SetTextProperties(&textProperties);
          
        sprintf(text1,"%4d",cal);
      /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
        oled.TextBox((uint8_t *)text1,70,50,20,15);
        if(once==0)
        {
            wait(8);
            once=1;
            }
       } 
             
    }

void StartHaptic(void)
{
    hapticTimer.start(30);
    haptic = 1;
}

void StopHaptic(void const *n) {
    haptic = 0;
    hapticTimer.stop();
}

void ButtonUp(void)
{
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;
     /* Fills the screen with solid black */         
    
    
        oled_text_properties_t textProperties = {0};
        oled.GetTextProperties(&textProperties);
        //oled1.clear(BLACK);
        //oled.TextBox((uint8_t *)text,0,0,96,96);
        wait(1);
     /* Get OLED Class Default Text Properties */
        //for(int i=0;i<5;i++)
       // {
        
        /* Set text properties to white and right aligned for the dynamic text */
        textProperties.fontColor = COLOR_RED;
        textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
        oled.SetTextProperties(&textProperties);  
        strcpy((char *) text,"");
        strcpy((char *) text,"Heart Rate");
        oled.Label((uint8_t *)text,0,20);
        strcpy((char *) text,"");
        sprintf(text,"00");
        oled.Label((uint8_t *)text,70,20);
        wait(2); 
        textProperties.fontColor = COLOR_RED;
        textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
        oled.SetTextProperties(&textProperties);
        sprintf(text,"%i",sample );
        oled.Label((uint8_t *)text,70,20);
        
        if(sample>150){
            textProperties.fontColor = COLOR_GREEN;
        textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
        oled.SetTextProperties(&textProperties);  
        strcpy((char *) text,"");
        strcpy((char *) text,"Slow Down");
        oled.Label((uint8_t *)text,0,7);
        strcpy((char *) text,"");
        }
        wait(8);
        //oled.FillScreen(COLOR_BLACK);
        //}
       // strcpy((char *) text,"");
        //oled.Label((uint8_t *)text,0,0);
        //oled.TextBox((uint8_t *)text,0,0,96,96); 
        //oled.FillScreen(COLOR_BLACK);
        //oled1.clear(BLACK);
            
       // StopHaptic(1);
}



void ButtonDown(void)
{
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;
    /* Turn on the backlight of the OLED Display */
    oled_text_properties_t textProperties = {0};
        oled.GetTextProperties(&textProperties);
        textProperties.fontColor = COLOR_RED;
    textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
    oled.SetTextProperties(&textProperties);
        sprintf(text,"%d",00);
        oled.Label((uint8_t *)text,70,20);
    
}

void ButtonRight(void)
{
    StartHaptic();
    
    redLed      = LED_OFF;
    greenLed    = LED_OFF;
    blueLed     = LED_ON;
    oled_text_properties_t textProperties = {0};
        oled.GetTextProperties(&textProperties);
        //oled1.clear(BLACK);
        //oled.TextBox((uint8_t *)text,0,0,96,96);
        wait(1);
     /* Get OLED Class Default Text Properties */
        //for(int i=0;i<5;i++)
       // {
        
        /* Set text properties to white and right aligned for the dynamic text */
        //if(bool maxim_max30102_init()==true){
            //maxim_max30102_read_fifo(0,0);
        /*    textProperties.fontColor = COLOR_GREEN;
        textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
        oled.SetTextProperties(&textProperties); 
        strcpy((char *) text1,"FEVER"); 
      /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
       /* oled.TextBox((uint8_t *)text1,70,50,20,15);
        wait(5);
            }
        /*textProperties.fontColor = COLOR_GREEN;
        textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
        oled.SetTextProperties(&textProperties);  
        strcpy((char *) text,"");
        strcpy((char *) text,"FEVER");
        oled.Label((uint8_t *)text,0,7);
        strcpy((char *) text,"");
        sprintf(text,"%i", rand() % 3 + 37);
        oled.Label((uint8_t *)text,70,7);
        wait(7);
        */
         oled.DimScreenON();
}

void ButtonLeft(void)
{
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_ON;
    blueLed     = LED_OFF;
    /*
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);
    heart.enable();
    heart.heartRate_SendToKW40( data)
    textProperties.fontColor = COLOR_RED;
    textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
    oled.SetTextProperties(&textProperties);  
    strcpy((char *) text,"");
    strcpy((char *) text,"Heart Rate");
    oled.Label((uint8_t *)text,0,20);
    strcpy((char *) text,"");
    sprintf(text,"%i", data);
    oled.Label((uint8_t *)text,70,20);
    wait(7);
    */
}

void ButtonSlide(void)
{
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_ON;
    blueLed     = LED_ON;
}