#include "mbed.h"

//*****************************************************************************//
// Distribucion pines sensor de color

    //DigitalOut S0(PA_12); // D2 | 0 0 POWER DOWN | 0 1 2% | 1 0 20% | 1 1 100%  
    //DigitalOut S1(PB_3);  // D3 | 0 1 20%
    DigitalIn Out(PA_7);  // D11 | SALIDA SENSOR
    DigitalOut S2(PA_6);  // D12 | 0 0 RED | 0 1 BLUE | 1 0 ALL | 1 1 GREEN
    DigitalOut S3(PA_5);  // D13 | 0 0 RED | 0 1 BLUE | 1 0 ALL | 1 1 GREEN
    
//*****************************************************************************//
// FUNCION AUXILIAR PARA LEER EL COLOR

int readAux()
{
    Timer Tiempo;
    int inicial = 0, final = 0, resultado = 0;
    
    Tiempo.start();
            
    while(Out == 1);
    while(Out == 0);
    while(Out == 1);
        
    inicial = Tiempo.read_us();
        
    while (Out == 0);
        
    final = Tiempo.read_us();
        
    resultado = (final - inicial);
    return (resultado); 
}

//*****************************************************************************//
// FUNCION PARA LEER EL COLOR

int readColor()
{
    int rojo = 0, azul = 0, verde = 0;
    int color;
    
    //S0.write(1);
    //S1.write(1);
    
    S2.write(0);
    S3.write(0);
    rojo = readAux();
            
    S2.write(0);
    S3.write(1);
    azul = readAux();
            
    S2.write(1);
    S3.write(1);
    verde = readAux();
    
    if (rojo < azul && verde > azul && rojo < 35)
    {   color = 1;  }
            
    else if (azul < rojo && azul < verde && verde < rojo)
    {   color = 2;  }
            
    else if (rojo < azul && azul > verde )  
    {   color = 3;  }
            
    else 
    {   color = 4;  }
    
return (color);

}