#ifndef __TOUCHPANEL_H__
#define __TOUCHPANEL_H__

#include "mbed.h"
#include "math.h"

/******************************************************************************/
/****************************** TouchPanel ************************************/
/******************************************************************************/

/* The touch panel is polled in 50ms intervals. */
#define POLLING_INVERVAL    0.05f

/* X or Y coordinate if no touch was detected. */
#define NO_TOUCH_VAL        0xFFFF

/* If the absolute value of the difference between the values of coherent
 * +/- inputs pins does not exceed this value the panel was touched. */
#define TOUCH_THRESHOLD     0.005f

/* The width of the TFT display in px. */
#define WIDTH               320
/* The height of the TFT display in px. */
#define HEIGHT              240

/* Border calibration constants. */
#define TOP                 0.8f    // Y coordinate
#define BOTTOM              0.2f    // Y coordindate
#define LEFT                0.12f   // X coordinate
#define RIGHT               0.89f   // X coordinate

/***************************************************************************//**
 * @brief  TouchPanel driver for the TFT color display MI0283QT-9A (320x240).
 * @author Mario Poneder
 * @date   28/01/2014
*******************************************************************************/
class TouchPanel
{
    typedef void (*pTouchCallback_t)(unsigned short, unsigned short);

private:

    PinName xPos;           // X+ pin
    PinName xNeg;           // X- pin
    PinName yPos;           // Y+ pin
    PinName yNeg;           // Y- pin

    DigitalOut *xPosOut;    // X+ out
    DigitalOut *xNegOut;    // X- out
    DigitalOut *yPosOut;    // Y+ out
    DigitalOut *yNegOut;    // Y- out
    
    AnalogIn *xPosIn;       // X+ in
    AnalogIn *xNegIn;       // X- in
    AnalogIn *yPosIn;       // Y+ in
    AnalogIn *yNegIn;       // Y- in
    
    Ticker pollPanelTicker; // Calls the PollPanel method in specified intervals.
    pTouchCallback_t touchCallbackFunction;
    bool xy;
    
    void PrepareYRead(void);
    void PrepareXRead(void);
    void PollPanel(void);

public:
    
    TouchPanel(PinName xPos, PinName xNeg, PinName yPos, PinName yNeg);
    void SetTouchCallbackFunction(pTouchCallback_t touchCallbackFunction);
};

#endif /* __TOUCHPANEL_H__ */
