 #include "mbed.h"
 #include "DHT.h"
 #include "button_group.hpp"
 #include "TS_DISCO_F746NG.h"
 #include "LCD_DISCO_F746NG.h"
 
 Serial pc(USBTX, USBRX);
DHT sensor(A0,DHT11);
 uint8_t text[30];
  uint8_t text1[30];
   uint8_t text2[30];

LCD_DISCO_F746NG lcd_;
TS_DISCO_F746NG ts_;
 
 int main() {
     lcd_.Clear(LCD_COLOR_WHITE);
    lcd_.SetBackColor(LCD_COLOR_WHITE);
    lcd_.SetTextColor(LCD_COLOR_BLACK);
    
    int err;
    pc.printf("\r\nDHT Test program");
    pc.printf("\r\n******************\r\n");
    wait(1); // wait 1 second for device stable status
    while (1) {
        
        err = sensor.readData();
        if (err == 0) {
            sprintf((char*)text, "Temperatura: %4.2f C",sensor.ReadTemperature(CELCIUS));
            lcd_.DisplayStringAt(0, LINE(5),text , CENTER_MODE);
            sprintf((char*)text1, "Umidita': %4.2f %",sensor.ReadHumidity());
            lcd_.DisplayStringAt(0, LINE(6),text1 , CENTER_MODE);
            
            pc.printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
            pc.printf("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
            pc.printf("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
            pc.printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
            pc.printf("Dew point is %4.2f  \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            pc.printf("Dew point (fast) is %4.2f  \r\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
        } else
            pc.printf("\r\nErr %i \n",err);

        wait(1);
    }
}