#include "mbed.h"
#include "MODSERIAL.h"

AnalogIn potmetervalue1     (A1);
AnalogIn potmetervalue2     (A2);
DigitalIn button2           (D10);                  //Let op, is deze niet bezet?
InterruptIn encoderA        (D9);
InterruptIn encoderB        (D8);

DigitalOut directionpin1    (D4);
DigitalOut directionpin2    (D7);
PwmOut pwmpin1              (D5);
PwmOut pwmpin2              (D6);


MODSERIAL pc(USBTX, USBRX);


//Global variables
int encoder = 0;
   

//Functions
void encoderA_rise()       
{
    if(encoderB==false)
    {
        encoder++;
    }
    else
    {
        encoder--;
    }
}

void encoderA_fall()      
{
    if(encoderB==true)
    {
        encoder++;
    }
    else
    {
        encoder--;
    }
}

void encoderB_rise()       
{
    if(encoderA==true)
    {
        encoder++;
    }
    else
    {
        encoder--;
    }
}

void encoderB_fall()      
{
    if(encoderA==false)
    {
        encoder++;
    }
    else
    {
        encoder--;
    }
}


// Main function start.

int main()
{ 
    pc.baud(115200);
    pc.printf("hello\n\r");
    pwmpin1.period_us(60); //60 microseconds PWM period, 16.7 kHz 

    encoderA.rise(&encoderA_rise);
    encoderA.fall(&encoderA_fall);
    encoderB.rise(&encoderB_rise);
    encoderB.fall(&encoderB_fall);
    
    while (true)
    {
          
          float u1 = potmetervalue1;
          float u2 = potmetervalue2;
          
          float m1 = ((u1*2.0f)-1.0f);
          float m2 = ((u2*2.0f)-1.0f);
          
          //pc.printf("motorwaarde 1: %f en %f\n\r ",m1,m2);
        
        if(m1>0.5)
        {
            pc.printf("Ik heet Klaas\n\r");
            directionpin1.write(1);        //Indien waar, motor draait rechtsom. Indien niet waar, motor draait linksom. 
            pwmpin1 = fabs(m1);
            //wait(1.0f);                   //zodat de code niet oneindig doorgaat.
                
        }
        else if(m1<-0.5)
        {
           pc.printf("Ik heet Bert\n\r");
            directionpin1.write(0);        //Indien waar, motor draait rechtsom. Indien niet waar, motor draait linksom. 
            pwmpin1 = fabs(m1);
            //wait(1.0f);                   //zodat de code niet oneindig doorgaat.
        }
        else
        {
            pwmpin1 = 0;
        }
        
        if(m2>0.5)
        {
            pc.printf("Ik heet Maria\n\r");
            directionpin2.write(1);        //Indien waar, motor draait rechtsom. Indien niet waar, motor draait linksom. 
            pwmpin2 = fabs(m2);
           // wait(1.0f);                   //zodat de code niet oneindig doorgaat.
                
        }
        else if(m2<-0.5)
        {
            pc.printf("Ik heet Ellis\n\r");
            directionpin2.write(0);        //Indien waar, motor draait rechtsom. Indien niet waar, motor draait linksom. 
            pwmpin2 = fabs(m2);
           // wait(1.0f);                   //zodat de code niet oneindig doorgaat.
        }
        else
        {
            pwmpin2 = 0;
        }  
                pc.printf("M1 waarde %f en M2 waarde %f \r\n",m1,m2);
                
        //pc.printf("Encoder count: %i \n\r",encoder);   //We moeten de encoder counts nog omzetten naar radialen of graden? 
    }
}

