#include "mbed.h"
#include "MODSERIAL.h"
#include "BiQuad.h"
#include "HIDScope.h"
#include <math.h>

//ATTENTION:    set mBed to version 151
//              set QEI to version 0, (gebruiken wij (nog) niet, is voor encoder)
//              set MODSERIAL to version 44
//              set HIDScope to version 7
//              set biquadFilter to version 7

AnalogIn emg0_in            (A0);                   //First raw EMG signal input
AnalogIn emg1_in            (A1);                   //Second raw EMG signal input

InterruptIn button1         (D10);                  //Is this one available? We need to make a map of which pins are used for what.
InterruptIn button2         (D11);

DigitalOut directionpin1    (D7);
DigitalOut directionpin2    (D4);
PwmOut pwmpin1              (D6);
PwmOut pwmpin2              (D5);

DigitalOut ledr             (LED_RED);
DigitalOut ledb             (LED_BLUE);
DigitalOut ledg             (LED_GREEN);


MODSERIAL pc(USBTX, USBRX);                       //Serial communication to see if the code works step by step, turn on if hidscope is off

//HIDScope    scope( 6 );                             //HIDScope set to 3x2 channels for 3 muscles, raw data + filtered

//Tickers
Ticker      HIDScope_tick;                          //Ticker for HIDScope
Ticker      filter_tick;                            //Ticker for EMG filter
Ticker      MovAg_tick;                             //Ticker to calculate Moving Average
Ticker      Motor_tick;                             //Ticker motor aansturen

//Global variables
const float T   = 0.002f;                           //Ticker period

//EMG filter
double emg0_filt, emg1_filt;                                                       //Variables for filtered EMG data channel 0, 1 and 2
double emg0_raw, emg1_raw;
double emg0_filt_x, emg1_filt_x;
const int windowsize = 150;                                                                      //Size of the array over which the moving average (MovAg) is calculated. (random number)
double sum, sum1, sum2;                                                                    //variables used to sum elements in array
double StoreArray0[windowsize], StoreArray1[windowsize];                //Empty arrays to calculate MoveAg
double movAg0, movAg1;                                                                   //outcome of MovAg (moet dit een array zijn??)

//Calibration variables
int x = -1;                                                                                      //Start switch, colour LED is blue.
int emg_cal = 0;                                                                                 //if emg_cal is set to 1, motors can begin to work in this code (!!)
const int sizeCal = 1500;                                                                        //size of the dataset used for calibration, eerst 2000
double StoreCal0[sizeCal], StoreCal1[sizeCal];                               //arrays to put the dataset of the calibration in
double Mean0,Mean1;                                                                        //average of maximum tightening
double Threshold0, Threshold1; 

//Biquad                                                                                         //Variables for the biquad band filters (alle 3 dezelfde maar je kan niet 3x 'emg0band' aanroepen ofzo)
BiQuadChain emg0filter;
BiQuad emg0band1( 7.29441e-01, -1.89276e-08, -7.29450e-01, -1.64507e-01, -7.26543e-01 );
BiQuad emg0band2( 1.00000e+00, 1.99999e+00, 9.99994e-01, 1.72349e+00, 7.79616e-01 );
BiQuad emg0band3( 1.00000e+00, -1.99999e+00, 9.99994e-01, -1.93552e+00, 9.39358e-01 );
BiQuad notch1( 9.91104e-01, -1.60364e+00, 9.91104e-01, -1.60364e+00, 9.82207e-01 );                //Notch filter biquad coefficients

BiQuadChain emg1filter;
BiQuad emg1band1( 7.29441e-01, -1.89276e-08, -7.29450e-01, -1.64507e-01, -7.26543e-01 );
BiQuad emg1band2( 1.00000e+00, 1.99999e+00, 9.99994e-01, 1.72349e+00, 7.79616e-01 );
BiQuad emg1band3( 1.00000e+00, -1.99999e+00, 9.99994e-01, -1.93552e+00, 9.39358e-01 );
BiQuad notch2( 9.91104e-01, -1.60364e+00, 9.91104e-01, -1.60364e+00, 9.82207e-01 );                //Notch filter

//Functions

void switch_to_calibrate()
{
    x++;                        //Every time function gets called, x increases. Every button press --> new calibration state.
                                //Starts with x = -1. So when function gets called 1 time, x = 0.  In the end, x = 4 will reset to -1.

    if(x==0)                    //If x = 0, led is red
    {
        ledr = 0;
        ledb = 1;
        ledg = 1;
    }
    else if (x==1)              //If x = 1, led is blue
    {
        ledr = 1;
        ledb = 0;
        ledg = 1;
    }
    else                        //If x = 3 or 4, led is white
    {
        ledr = 0;
        ledb = 0;
        ledg = 0;
    }
   
    if(x==3)                    //Reset back to x = -1
    {
        x = -1;
        emg_cal=0;              //reset, motors off
    }
}
    
        
void calibrate(void)
{
    switch(x)
    {
        case 0:                                         //If calibration state 0:
        {
            sum = 0.0;
            for(int j = 0; j<=sizeCal-1; j++)           //Array filled with datapoints from the EMGfilter signal of muscle 0
            {
                StoreCal0[j] = emg0_filt;
                sum+=StoreCal0[j];
                wait(0.001f);                           //Does there need to be a wait?
            }
            Mean0       = sum/sizeCal;                  //Calculate mean of the datapoints in the calibration set (2000 samples)
            Threshold0  = Mean0/2;                      //Threshold calculation = 0.5*mean                                            
            break;                                      //Stop. Threshold is calculated, we will use this further in the code
        }
        case 1:                                         //If calibration state 1:
        {
            sum = 0.0;                                  
            for(int j = 0; j<=sizeCal-1; j++)           //Array filled with datapoints from the EMGfilter signal of muscle 1
            {
                StoreCal1[j] = emg1_filt;
                sum+=StoreCal1[j];
                wait(0.001f);
            }
            Mean1       = sum/sizeCal;
            Threshold1  = Mean1/2;                      
            break;
        }
        case 2:                                         //EMG is calibrated, robot can be set to Home position.
        {
            emg_cal = 1;                                //This is the setting for which the motors can begin turning in this code (!!)
            wait(0.001f);
            break;
        }
        default:                                        //Ensures nothing happens if x is not 0,1 or 2.
        {
            break;
        }
    }
}

void EMGFilter0()
{   
    emg0_raw      = emg0_in.read();                      //give name to raw EMG0 data
    emg0_filt_x   = emg0filter.step(emg0_raw);           //Use biquad chain to filter raw EMG data
    emg0_filt     = abs(emg0_filt_x);                    //rectifier. LET OP: volgorde filter: band-notch-rectifier. Eerst band-rect-notch, stel er komt iets raars uit, dan Notch uit de biquad chain halen en aparte chain voor aanmaken.
}

void EMGFilter1()
{
    emg1_raw      = emg1_in.read();                      //give name to raw EMG1 data
    emg1_filt_x   = emg1filter.step(emg1_raw);           //Use biquad chain to filter raw EMG data
    emg1_filt     = abs(emg1_filt_x);                    //rectifier. LET OP: volgorde filter: band-notch-rectifier. Eerst band-rect-notch.
}
 
void MovAg()                                         //Calculate moving average (MovAg), klopt nog niet!!
{
    for (int i = windowsize-1; i>=0; i--)            //Make arrays for the last datapoints of the filtered signals
    {
        StoreArray0[i] = StoreArray0[i-1];           //Shifts the i'th element one place to the right, this makes it "rolling or moving" average.
        StoreArray1[i] = StoreArray1[i-1];
    }
    
    StoreArray0[0] = emg0_filt;                      //Stores the latest datapoint of the filtered signal in the first element of the array
    StoreArray1[0] = emg1_filt;
    
    sum1 = 0.0;
    sum2 = 0.0;
    
    for(int a = 0; a<= windowsize-1; a++)            //Sums the elements in the arrays
    {
        sum1 += StoreArray0[a];
        sum2 += StoreArray1[a];
    }
    
    movAg0 = sum1/windowsize;                        //calculates an average in the array
    movAg1 = sum2/windowsize;
    //serial getallen sturen, als het 1 getal is gaat hier wat fout, als het een reeks is dan gaat er bij de input naar HIDscope wat fout.
}

void emg_filtered()             //Call all filter functions
{
    EMGFilter0();
    EMGFilter1();
}

void motor_control()
{
    while(emg_cal==1)                              //After calibration is finished, emg_cal will be 1. Otherwise 0. 
    { 
               
                if(movAg0>Threshold0)                               //If the filtered EMG signal of muscle 0 is higher than the threshold, motor1 will turn in 1 direction
                {
                       pwmpin1 = 0.05;
                       directionpin1.write(1);                      //rotation down
                       
                       ledr = 1;                                    //Blue
                       ledb = 0;
                       ledg = 1;
                       
                }
                else if(movAg1>Threshold1)                          //If the filtered EMG signal of muscle 1 is higher than the threshold, motor2 will turn in 1 direction
                {
                       pwmpin2 = 0.05;
                       directionpin2.write(1);                      //forward translation
                       ledr = 0;                                    //red
                       ledb = 1;
                       ledg = 1;
                }
                else                                               //If not higher than the threshold, motors will not turn at all
                {
                    pwmpin1 = 0;                                  //Motoren doen niets
                    pwmpin2 = 0;
                       
                    ledr = 0;                                   //white
                    ledb = 0;
                    ledg = 0;
                }
                       
        break;           
        }
}


int main()
{         
        pc.baud(115200);
        pc.printf("Hello World!\r\n");                                                          //Serial communication only works if hidscope is turned off.
        pwmpin1.period_us(60);                      //60 microseconds PWM period, 16.7 kHz 

        emg0filter.add( &emg0band1 ).add( &emg0band2 ).add( &emg0band3 ).add( &notch1 );        //attach biquad elements to chain
        emg1filter.add( &emg1band1 ).add( &emg1band2 ).add( &emg1band3 ).add( &notch2 );
        
    while(true)
    {
        filter_tick.attach(&emg_filtered,T);        //EMG signals filtered every T sec.
        MovAg_tick.attach(&MovAg,T);                //Moving average calculation every T sec.
        Motor_tick.attach(&motor_control,T);        //Test motor control
        
       // HIDScope_tick.attach(&HIDScope_sample,T);   //EMG signals raw + filtered to HIDScope every T sec.
        
    button1.rise(switch_to_calibrate);          //Switch state of calibration (which muscle)
    wait(0.2f);                                 //Wait to avoid bouncing of button
    button2.rise(calibrate);                    //Calibrate threshold for 3 muscles
    wait(0.2f);                                 //Wait to avoid bouncing of button
    
    pc.printf("x is %i\n\r",x);
    pc.printf("Movag0 = %f , Movag1 = %f, Movag2 = %f \n\r",movAg0, movAg1, movAg2);
    pc.printf("Thresh0 = %f , Thresh1 = %f, Thresh2 = %f \n\r",Threshold0, Threshold1, Threshold2);
    //wait(2.0f);    
    }      
}
