#include "mbed.h"
#include "MODSERIAL.h"
#include "BiQuad.h"
#include "HIDScope.h"
#include <math.h>

//ATTENTION:    set mBed to version 151
//              set QEI to version 0, (gebruiken wij (nog) niet, is voor encoder)
//              set MODSERIAL to version 44
//              set HIDScope to version 7
//              set biquadFilter to version 7

AnalogIn emg0_in            (A0);                   //First raw EMG signal input
AnalogIn emg1_in            (A1);                   //Second raw EMG signal input
AnalogIn emg2_in            (A2);                   //Third raw EMG signal input
DigitalOut myled            (LED_GREEN);            //Led to test if the code works

//MODSERIAL pc(USBTX, USBRX);                       //Serial communication to see if the code works step by step, turn on if hidscope is off

HIDScope    scope( 6 );                             //HIDScope set to 3x2 channels for 3 muscles, raw data + filtered

//Tickers
Ticker      HIDScope_tick;                          //Ticker for HIDScope
Ticker      filter_tick;                            //Ticker for EMG filter
Ticker      MovAg_tick;                             //Ticker to calculate Moving Average

//Global variables
const float T   = 0.002f;                           //Ticker period

//EMG filter
double emg0_filt, emg1_filt, emg2_filt;                                                          //Variables for filtered EMG data channel 0, 1 and 2
double emg0_raw, emg1_raw, emg2_raw;
const int windowsize = 150;                                                                      //Size of the array over which the moving average (MovAg) is calculated. (random number)
double sum, sum1, sum2, sum3;                                                                    //variables used to sum elements in array
double StoreArray0[windowsize], StoreArray1[windowsize], StoreArray2[windowsize];                //Empty arrays to calculate MoveAg
double movAg0, movAg1, movAg2;                                                                   //outcome of MovAg (moet dit een array zijn??)

//Biquad                                                                                         //Variables for the biquad band filters (alle 3 dezelfde maar je kan niet 3x 'emg0band' aanroepen ofzo)
BiQuadChain emg0filter;
BiQuad emg0band1( 7.29441e-01, -1.89276e-08, -7.29450e-01, -1.64507e-01, -7.26543e-01 );
BiQuad emg0band2( 1.00000e+00, 1.99999e+00, 9.99994e-01, 1.72349e+00, 7.79616e-01 );
BiQuad emg0band3( 1.00000e+00, -1.99999e+00, 9.99994e-01, -1.93552e+00, 9.39358e-01 );
BiQuad notch1( 9.91104e-01, -1.60364e+00, 9.91104e-01, -1.60364e+00, 9.82207e-01 );                //Notch filter biquad coefficients

BiQuadChain emg1filter;
BiQuad emg1band1( 7.29441e-01, -1.89276e-08, -7.29450e-01, -1.64507e-01, -7.26543e-01 );
BiQuad emg1band2( 1.00000e+00, 1.99999e+00, 9.99994e-01, 1.72349e+00, 7.79616e-01 );
BiQuad emg1band3( 1.00000e+00, -1.99999e+00, 9.99994e-01, -1.93552e+00, 9.39358e-01 );
BiQuad notch2( 9.91104e-01, -1.60364e+00, 9.91104e-01, -1.60364e+00, 9.82207e-01 );                //Notch filter

BiQuadChain emg2filter;
BiQuad emg2band1( 7.29441e-01, -1.89276e-08, -7.29450e-01, -1.64507e-01, -7.26543e-01 );
BiQuad emg2band2( 1.00000e+00, 1.99999e+00, 9.99994e-01, 1.72349e+00, 7.79616e-01 );
BiQuad emg2band3( 1.00000e+00, -1.99999e+00, 9.99994e-01, -1.93552e+00, 9.39358e-01 );
BiQuad notch3( 9.91104e-01, -1.60364e+00, 9.91104e-01, -1.60364e+00, 9.82207e-01 );                //Notch filter

//Functions

void HIDScope_sample()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0,emg0_raw);
    scope.set(1,emg0_filt);
    //scope.set(1,movAg0);          //als moving average werkt
    scope.set(2,emg1_raw);
    scope.set(3,emg1_filt);
    //scope.set(3,movAg1);          //als moving average werkt
    scope.set(4,emg2_raw);
    scope.set(5,emg2_filt);
    //scope.set(5,movAg2);          //als moving average werkt

    scope.send();                   //Send data to HIDScope server
}

void EMGFilter0()
{   
    double emg0_raw      = emg0_in.read();                      //give name to raw EMG0 data
    double emg0_filt_x   = emg0filter.step(emg0_raw);           //Use biquad chain to filter raw EMG data
    double emg0_filt     = abs(emg0_filt_x);                    //rectifier. LET OP: volgorde filter: band-notch-rectifier. Eerst band-rect-notch, stel er komt iets raars uit, dan Notch uit de biquad chain halen en aparte chain voor aanmaken.
}

void EMGFilter1()
{
    double emg1_raw      = emg1_in.read();                      //give name to raw EMG1 data
    double emg1_filt_x   = emg1filter.step(emg1_raw);           //Use biquad chain to filter raw EMG data
    double emg1_filt     = abs(emg1_filt_x);                    //rectifier. LET OP: volgorde filter: band-notch-rectifier. Eerst band-rect-notch.
}

void EMGFilter2()
{
    double emg2_raw      = emg2_in.read();                      //Give name to raw EMG1 data
    double emg2_filt_x   = emg2filter.step(emg2_raw);           //Use biquad chain to filter raw EMG data
    double emg2_filt     = abs(emg2_filt_x);                    //Rectifier. LET OP: volgorde filter: band-notch-rectifier.
}
 
void MovAg()                                         //Calculate moving average (MovAg), klopt nog niet!!
{
    for (int i = windowsize-1; i>=0; i--)            //Make arrays for the last datapoints of the filtered signals
    {
        StoreArray0[i] = StoreArray0[i-1];           //Shifts the i'th element one place to the right, this makes it "rolling or moving" average.
        StoreArray1[i] = StoreArray1[i-1];
        StoreArray2[i] = StoreArray2[i-1];
    }
    
    StoreArray0[0] = emg0_filt;                      //Stores the latest datapoint of the filtered signal in the first element of the array
    StoreArray1[0] = emg1_filt;
    StoreArray2[0] = emg2_filt;
    
    sum1 = 0.0;
    sum2 = 0.0;
    sum3 = 0.0;
    
    for(int a = 0; a<= windowsize-1; a++)            //Sums the elements in the arrays
    {
        sum1 += StoreArray0[a];
        sum2 += StoreArray1[a];
        sum3 += StoreArray2[a];
    }
    
    movAg0 = sum1/windowsize;                        //calculates an average in the array
    movAg1 = sum2/windowsize;
    movAg2 = sum3/windowsize;
    //serial getallen sturen, als het 1 getal is gaat hier wat fout, als het een reeks is dan gaat er bij de input naar HIDscope wat fout.
}

void emg_filtered()             //Call all filter functions
{
    EMGFilter0();
    EMGFilter1();
    EMGFilter2();
}


int main()
{         
        //pc.baud(115200);
        //pc.printf("Hello World!\r\n");                                                          //Serial communication only works if hidscope is turned off.
        myled == 0;                                                                               //Does the code work?
        
        emg0filter.add( &emg0band1 ).add( &emg0band2 ).add( &emg0band3 ).add( &notch1 );        //attach biquad elements to chain
        emg1filter.add( &emg1band1 ).add( &emg1band2 ).add( &emg1band3 ).add( &notch2 );
        emg2filter.add( &emg2band1 ).add( &emg2band2 ).add( &emg2band3 ).add( &notch3 );

        filter_tick.attach(&emg_filtered,T);        //EMG signals filtered every T sec.
        MovAg_tick.attach(&MovAg,T);                //Moving average calculation every T sec.
        HIDScope_tick.attach(&HIDScope_sample,T);   //EMG signals raw + filtered to HIDScope every T sec.
        
        while(1){}
}
