#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"

AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );

Ticker      filter_timer;
HIDScope    scope( 4 );
DigitalOut  led1(LED_RED);
DigitalOut  led2(LED_BLUE);

volatile bool filter_timer_go=false;

double EMGright, EMGleft, inR;
double averageEMGr =0;
double averageEMGl =0;

void filter_timer_act(){filter_timer_go=true;};

BiQuadChain bcq1;
BiQuadChain bcq2;
// Notch filter wo=50; bw=wo/35
BiQuad bq1(9.9821e-01,-1.9807e+00,9.9821e-01,-1.9807e+00,9.9642e-01);
// High pass Butterworth filter 2nd order, Fc=10;
BiQuad bq2(9.8239e-01,-1.9648e+00,9.8239e-01,-1.9645e+00,9.6508e-01);
// Low pass Butterworth filter 2nd order, Fc = 8;
BiQuad bq3(5.6248e-05,1.1250e-04,5.6248e-05,-1.9787e+00,9.7890e-01);


// In the following: R is used for right arm, L is used for left arm!
void FilteredSample()
{   
    double inR = emg0.read();
    double inL = emg1.read();
    
    double outRfilter1 = bcq1.step(inR);
    double outRrect= fabs(outRfilter1);
    double outRenvelope= bcq2.step(outRrect);
    
    double outLfilter1 = bcq1.step(inL);
    double outLrect = fabs(outLfilter1);
    double outLenvelope= bcq2.step(outLrect);

    //pc.printf("Detrend EMG = %f\n\r",inR);
    //pc.printf("EMG signal= %f\n\r",emg0.read());
    //pc.printf("average EMG right = %f\n\r",averageEMGr);
    
    scope.set(0, inR);
    scope.set(1, inL);
    scope.set(2, outRenvelope);
    scope.set(3, outLenvelope);
    
    scope.send();
    // To indicate that the function is working, the LED is toggled*/
    led2 = !led2;
}

int main()
{   
    led1=1;
    led2=1;
    led2=!led2;

    bcq1.add(&bq1).add(&bq2);
    bcq2.add(&bq3);
    
      
    filter_timer.attach(&filter_timer_act, 0.0004); //2500Hz (same as with filter coefficients on matlab!!! Thus adjust!)
        //pc.printf("\rMain-loop\n\r");
        //pc.printf("Detrend EMG = %f\n\r",inR);
        
        while(1)
        {
        if (filter_timer_go){
                filter_timer_go=false;
                FilteredSample();}
        }
}