#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"


//Define objects
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );

Ticker      sample_timer;
HIDScope    scope( 4 );
DigitalOut  led(LED1);

BiQuadChain bcq;
// Notch filter wo=50; bw=wo/35
BiQuad bq1(9.7805e-01,-1.1978e-16,9.7805e-01,1.0000e+00,-1.1978e-16,9.5610e-01);
// High pass Butterworth filter 2nd order, Fc=10;
BiQuad bq2(9.8239e-01,-1.9648e+00,9.8239e-01,1.0000e+00,-1.9645e+00,9.6508e-01);
// Low pass Butterworth filter 2nd order, Fc = 8;
BiQuad bq3(5.6248e-05,1.1250e-04,5.6248e-05,1.0000e+00,-1.9787e+00,9.7890e-01);
// Low pass Butterworth filter 4th order, Fc = 450; plited up in 2x2nd order
BiQuad bq4(1.0000e+00,2.0000e+00,1.0000e+00,1.0000e+00,-4.6382e-01,8.9354e-02);
BiQuad bq5(1.0000e+00,2.0000e+00,1.0000e+00,1.0000e+00,-6.3254e-01,4.8559e-01);

/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
void sample()
{
    double inR = emg0.read();
    double inL = emg1.read();
    double outRnotch = bq1.step(inR);
    double outRhigh = bq2.step(outRnotch);
    double outRrect = fabs(outRhigh);
    double outRlow = bcq.step(outRrect);
    double outLnotch = bq1.step(inL);
    double outLhigh = bq2.step(outLnotch);
    double outLrect = fabs(outLhigh);
    double outLlow = bcq.step(outLrect);
    
    scope.set(0, inR);
    scope.set(1, inL);
    scope.set(2, outRlow);
    scope.set(3, outLlow);
    
    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}
/*
 //Internet: http://stackoverflow.com/questions/9334185/how-to-get-an-average-in-c    
double average(int n, ...)          // where n - count of argument (number)
{  
    int *p = &n;                   // get pointer on list of number in stack
    p++;                           // get first number
    double *pp = (double *)p;      // transformation of the pointer type
    double sum = 0; 
    for ( int i = 0; i < n; pp++, i++ ) //looking all stack
       sum+=(*pp);                 // summarize
    return sum/n;              //return average
    //(in the main)double avR = average();
    //double avL = average(); }
}*/

int main()
{   
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
    /*int calibrationTime = 0;
        while (calibrationTime<=10){
        calibrationTime++;
        sample_timer.attach(&sample, 0.002);
        
        //int counter = 10;
        //double size = 10/0.002; 
        char bufferEMGr[5000];
        char bufferEMGl[5000];
        double avR = average(bufferEMGr);
        double avL = average(bufferEMGl);
        // http://stackoverflow.com/questions/10990618/calculate-rolling-moving-average-in-c:
        int j = (int) (counter % size);
        int l = (int) (counter % size);
        char bufferR[j] = emg0.read();
        avg0 = (avg0 * size - buffer[j - 1 == -1 ? size - 1 : j - 1] + buffer[j]) / size;
        char bufferL[l] = emg1.read();
        avg1 = (avg1 * size - buffer[l - 1 == -1 ? size - 1 : l - 1] + buffer[l]) / size;
        //counter++;
         
        }*/
     
     
    bcq.add(&bq3).add(&bq4).add(&bq5);
    /*fabs(emg0.read()); //rectification
    fabs(emg1.read()); //rectification*/
    //bcq.add(&bq4).add(&bq5).add(&bq6).add(&bq7);
    
    sample_timer.attach(&sample, 0.0025); //2500Hz (same as with filter coefficients on matlab!!! Thus adjust!)
    while(1){}
}

