#include "mbed.h"
#include "F746_GUI.hpp"
#include "LCD_DISCO_F746NG.h"
#include "TextLCD.h"
#include <string>
#include <math.h>
#include "EthernetInterface.h"
#include "rtos.h"
#include "lwip/inet.h"
#include "lwip/netif.h"
#include "netif/etharp.h"
#include "lwip/dhcp.h"
#include "eth_arch.h"
#include "lwip/tcpip.h"
#include "NTPClient.h"
#include <stdio.h>


//Initialization of varius connections and interfaces





LCD_DISCO_F746NG lcd;
EthernetInterface eth;
Thread t1, t2, t3, t4, t5, t6;
NTPClient ntp;
TCPSocketConnection *sock;
//declare external funktions and pointers
extern void heartrate();
extern double *h_p;
extern double *hum;
extern double *t_p;
extern int *beats_per_min;
extern void smotor();
extern void temp();
extern void humidity();
//extern void sending();
//extern void proximity();

char ip_add[30];



/*void sending(message)
{

    sock = new TCPSocketConnection();
    sock->connect("192.168.8.115", 12345);
    sock->set_blocking(false, (int) (60 * 1000));
    //std::string s = std::to_string(message);
    //char s = '0'+message;
    //const char *cstr = s.c_str();
    sock->send(message, 127);

}*/


int main()
{
    /*double humid;
    while(1){
        t5.start(humidity);
        char humidity_levels[31];
         humid = *hum;
        sprintf(humidity_levels, "%.40f", humid);

        lcd.DisplayStringAt(-10, LINE(8), (uint8_t *)humidity_levels, CENTER_MODE);

        wait(0.5);
        }*/
    //t3.start(smotor);


    //First we check if the ethernet interface was able to initialize
    if(eth.init()!=0) {

        char eth_init [40];
        sprintf(eth_init, "EthernetInterface Initialize Error");
        lcd.DisplayStringAt(0, LINE(10), (uint8_t *)eth_init, CENTER_MODE);
        while (1) {
            wait(5);
        }
    }
    //check if the ethernet intercace is connected to a network.

    if(eth.connect()!=0) {
        char eth_conn[30];
        sprintf(eth_conn, "EthernetInterface Connect Error");
        lcd.DisplayStringAt(0, LINE(8), (uint8_t *)eth_conn, CENTER_MODE);
        char mac_add[15];
        sprintf(mac_add, "Mac: %s", eth.getMACAddress());
        lcd.DisplayStringAt(0, LINE(10), (uint8_t *)mac_add, CENTER_MODE);
        while (1) {
            wait(5);
        }
    }
    /*

    char net_mask[30];
    char gate_Way[30];
    char dhcp_status[30];
    */

    /*Display the varius information achived from the dhcp server,
    It is also possible to set all these values manually,
    if no dhcp server is available
    */

    //used for troupleshooting with the network configuration
    /*
    sprintf(ip_add, "IP Address is %s", eth.getIPAddress());
    sprintf(net_mask, "NetMask is %s", eth.getNetworkMask());
    sprintf(gate_Way, "Gateway Address is %s", eth.getGateway());
    sprintf(dhcp_status, "Ethernet Setup OK");
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)ip_add, CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)net_mask, CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)gate_Way, CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(8), (uint8_t *)dhcp_status, CENTER_MODE);
    lcd.Clear(LCD_COLOR_GREEN); */
    
    
    //Connects to a danish NTP server to syncronise time and date. 
    if (ntp.setTime("1.dk.pool.ntp.org") == 0) {
        char ntp_message [50];
        time_t ctTime;
        ctTime = time(NULL);
        sprintf(ntp_message, "%s \r\n", ctime(&ctTime));
        //sprintf(ntp_message, "Time is set to : %s \r\n", ctime(&ctTime));
        lcd.DisplayStringAt(-10, LINE(8), (uint8_t *)ntp_message, CENTER_MODE);

    } else {

        lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"Error getting time", CENTER_MODE);
    }
    wait(1);
    lcd.Clear(LCD_COLOR_GREEN);



    //This is the main tasks included in the programm
    sprintf(ip_add, "IP Address is %s", eth.getIPAddress());
    //Creates a endless loop that works as the "main menu"
    while(1) {
        Button b1(300, 3, 70, 40, "Hjerterytme", Font16);
        Button b2(50, 3, 70, 40, "Lyd og temp", Font16);
        Button b3(150, 3, 70, 40, "Send", Font16);
        lcd.DisplayStringAt(0, LINE(10), (uint8_t *)ip_add, CENTER_MODE);

        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Commence Initial Testing...", CENTER_MODE);


        lcd.DisplayStringAt(0, LINE(6), (uint8_t *) "Christoffer Bisander", CENTER_MODE);

        if (b1.Touched()) { // switch to the heart rate monitor when b1 is clicked
            lcd.SetTextColor(LCD_COLOR_RED);
            //Spawn a thread that start monitoring the heartrate
            t2.start(heartrate);
            lcd.Clear(LCD_COLOR_GREEN);
            char heart_rate_current[50];
            char beats_per_min_final[10];
            double hr;
            int bpm;
            Button stop_hr(400, 3, 70, 40, "Exit", Font16);
            //from the pointer assigned in the hearrate function we constantly read the new vallues from the heartrate monitor. 
            while(1) {
                hr = *h_p;
                bpm = *beats_per_min;
                sprintf(heart_rate_current, "hjerterytme: %.8f", hr);
                sprintf(beats_per_min_final, "Din puls er: %i", bpm);
                //sending(bpm);
                lcd.DisplayStringAt(0, LINE(10), (uint8_t *)beats_per_min_final, CENTER_MODE);
                lcd.DisplayStringAt(0, LINE(14), (uint8_t *)heart_rate_current, CENTER_MODE);
                //if the exit button is pressed the thread is terminated and we return to the main menu.
                if (stop_hr.Touched()) {
                    t2.terminate();
                    break;
                } else {

                }
                wait(0.1);
            }

            t2.join();
            lcd.Clear(LCD_COLOR_BLACK);
        }
        //Switch to the temperature monitoring mode 
        if(b2.Touched()) {
            lcd.SetTextColor(LCD_COLOR_RED);
            //Spawn a thread that constantly monitor the temperature, and calculates the avarage temperature over a 5 sec period. 
            t2.start(temp);
            lcd.Clear(LCD_COLOR_GREEN);
            char current_temp[20];
            double tp;
            Button stop_hr(400, 3, 70, 40, "Exit", Font16);
            while(1) {
                tp = *t_p;
                //If the temperatur reached a certain limit, the motor start the idea here would be that it could be used as a climate system etc. 
                if(tp>22.0) {
                    t4.start(smotor);
                } else {
                }

                sprintf(current_temp, "temp: %.8f", tp);
                lcd.DisplayStringAt(0, LINE(14), (uint8_t *)current_temp, CENTER_MODE);
                if (stop_hr.Touched()) {
                    t2.terminate();
                    break;
                } else {

                }
                wait(0.5);
            }

            t2.join();
            lcd.Clear(LCD_COLOR_BLACK);
        }
        //This is primarly a proof of concept it sends af message to a TCP socket running on a different machine. 
        if(b3.Touched()) {
            lcd.SetTextColor(LCD_COLOR_RED);
            sock = new TCPSocketConnection();
            sock->connect("10.130.17.131", 12345);
            sock->set_blocking(false, (int) (60 * 1000));
            //std::string utf8 = u8"This is just a test";

            //message = "this is a test";

            sock->send("This is a test", 30);
            delete sock;
            //TCPSocketConnection().connect("192.168.8.115", 12345);
            //sending();
            //Send some data
        
        }
    }

}





