#include "mbed.h"
#include "PN532_SPI.h"
#include "snep.h"
#include "NdefMessage.h"
#include "NdefRecord.h"

InterruptIn irq(PTD5);
AnalogIn LM35(PTC2);
                   
#define LOG(args...)    pc.printf(args)//LOG of connection
SPI spi(PTD2, PTD3, PTC5);  // SPI(mosi, miso, clk)
PN532_SPI pn532spi(spi, PTD0);  // SPI (ss)
Serial pc(USBTX, USBRX); //serial connection to PC
DigitalOut led1(LED_RED);   //digital output
DigitalOut led2(LED_GREEN); //indicators

SNEP nfc(pn532spi);   //simple NDEF Exchange Protocol
uint8_t ndefBuf[128];

int main()
{  
float temp;  //measured temperature
while(1){temp=LM35.read();
#if 1    //initiator mode: starts connection with Android phone and 
         //sends NDEF message (text, url, MimeMedia or Application package)
        led1=1; //switch off RGB LED
        led2=1;
   
            LOG("\rBring close an NFC-enabled phone\n");
            int msgSize = nfc.read(ndefBuf, sizeof(ndefBuf));
            if (msgSize > 0) {   
            NdefMessage msg = NdefMessage(ndefBuf, msgSize);
            LOG("\r     Connection is successful.\n");
            int recordCount = msg.getRecordCount();
            for (int i = 0; i < recordCount; i++)
               {
               LOG("\r  NDEF Record %d\n",i+1);
               NdefRecord record = msg.getRecord(i);
               LOG("\r  TNF: %u", record.getTnf());
               LOG("\n\r  Type: %s", record.getType());
              
               // The TNF and Type should be used to determine how your application processes the payload
               int payloadLength = record.getPayloadLength();
               uint8_t payload[payloadLength];
               record.getPayload(payload);

               // Force the data into a String (might work depending on the content)
               string payloadAsString = "";
               for (int c = 0; c < payloadLength; c++) {
               payloadAsString += (char)payload[c];
               }
               if (payloadLength > temp*330){
                   led2=0;//scenario 3
                   LOG("\r\nTemperature is normal");
                   wait(3);
                   led2=1;
                   }
                   else{led1=0;
                   LOG("\r\nTemperature is too high");
                   wait(2);
                   led1=1;}
               LOG("\n\r  Received message '%s'\n", payloadAsString);
               LOG("\r  Command length %d\n", payloadLength);    
               printf("\r  Temperature %.2f C\n", temp*330);
               }   
               
           } else {
               LOG("\rConnection failed. Try again.\n");
               led1=0;
               wait(2);
               }
#endif
        led1=1;
        led2=1;
        wait(2); //polling cycle is 2 sec
}
}
