#include "mbed.h"
#include "MODSERIAL.h"
#include "HIDScope.h"
#include "QEI.h"
 
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led(LED_RED);
DigitalOut motor2direction(D4); //D4 en D5 zijn motor 2 (op het motorshield)
PwmOut motor2speed(D5);
DigitalIn button1(SW3);
DigitalIn EncoderA(D3);
DigitalIn EncoderB(D2);
HIDScope scope(2);
Ticker ScopeTime;

void ScopeSend()//Functie die de gegevens voor de scope uitleest en doorstuurt
{
    scope.set(0, motor2direction.read());
    scope.set(1, motor2speed.read());
    scope.send();
}

int main()
{
    motor2direction = 0;
    motor2speed = 0;
    wait(2);
    led = 1;
    pc.baud(115200);
    pc.printf("Tot aan loop werkt");
    ScopeTime.attach_us(&ScopeSend, 10e4);
    
    
    while (true) 
    {
       motor2direction = 1;
       motor2speed = 0.5f;
       pc.printf("1\n");
       wait(0.1);
       pc.printf("2222222222\n");
       motor2direction = 0;
       motor2speed = 0.3f;
       pc.printf("333\n");
      
    }
}