#include "mbed.h"
#include "HIDScope.h"
#include "MODSERIAL.h"
#include "biquadFilter.h"

//Define objects
    AnalogIn    EMG_left(A0); //Analog input
    AnalogIn    EMG_right(A1);   
    Ticker      SampleEMG;
    Ticker      ScopeTimer;
    Ticker      serial;
    HIDScope    scope(3);
    DigitalOut led(LED_RED);
    MODSERIAL pc(USBTX, USBRX);
    

// Declaring variables
    double EMG_L_f_v1 = 0, EMG_L_f_v2 = 0;
    double EMG_L_fh=0;
    double EMG_left_value;
    double EMG_f1;
    double EMG_f2;
    double Threshold = 0.08;    

// coëfficiënten
    const double BiGainEMG_Lh = 0.723601, BiGainEMG_Ll=0.983892;
    const double EMGh_a1 = -1.74355513773*BiGainEMG_Lh, EMGh_a2 = 0.80079826172*BiGainEMG_Lh, EMGh_b0 = 1.0*BiGainEMG_Lh, EMGh_b1 = -1.99697722433*BiGainEMG_Lh, EMGh_b2 = 1.0*BiGainEMG_Lh; //coefficients for high-pass filter
    const double EMGl_a1 = 1.96775103303*BiGainEMG_Ll, EMGl_a2 = 0.96827054038*BiGainEMG_Ll, EMGl_b0 = 1.0*BiGainEMG_Ll, EMGl_b1 = 1.99999993582*BiGainEMG_Ll, EMGl_b2 = 1.0*BiGainEMG_Ll; // coefficients for low-pass filter
    
// Filter creation    
    biquadFilter EMG_highpass (EMGh_a1, EMGh_a2, EMGh_b0, EMGh_b1, EMGh_b2);        // creates the high pass filter
    biquadFilter EMG_lowpass (EMGl_a1, EMGl_a2, EMGl_b0, EMGl_b1, EMGl_b2);         // creates the low pass filter
    
// EMG filtering function
void EMGfilter()
{
    EMG_left_value = EMG_left.read();
    EMG_f1 = EMG_highpass.step(EMG_left_value);
    EMG_f2 = EMG_lowpass.step(EMG_f1);
}

// HIDScope
    void ScopeSend()
    {
        scope.set(0, EMG_left_value);
        scope.set(1, EMG_f1);
        scope.set(2, EMG_f2);
        scope.send();
    }
    
// Serial communication
    void serial_()
    {
        pc.baud(115200);
        pc.printf("%d\n", EMG_L_fh);
    }
    
int main()
{
    SampleEMG.attach(&EMGfilter, 0.002);
    ScopeTimer.attach(&ScopeSend, 0.002);
    while(1) 
    {
        if (fabs(EMG_f2) > Threshold)
        {
            led.write(0);
        }
        
        else
        {
            led.write(1);
        }
    }
}