#include "FrenchTime.h"




uint8_t FrenchTime::frenchTimeOffset(uint8_t day, uint8_t month, int year)
{
    //Avril, Mai, Juin, Juillet, Aout, Septembre
    if (month > MARS && month < OCTOBRE) {
        return UTC_TIME_OFFSET + 1;
    }
    // Janvier, Février, Novembre, Décembre
    else if (month < MARS || month > OCTOBRE) {
        return UTC_TIME_OFFSET;
    }
    //Mars ou Octobre
    else {
        if (MARS == month) {
            if (day >= lastSundayOfMonth(month, year)) {
                return UTC_TIME_OFFSET + 1;
            }
        }
        //OCTOBRE
        else {
            if (day < lastSundayOfMonth(month, year)) {
                return UTC_TIME_OFFSET + 1;
            }
        }
        return UTC_TIME_OFFSET;
    }
}



uint8_t FrenchTime::lastSundayOfMonth(uint8_t m, int y)
{
    for (uint8_t d = DAYS_IN_MARS; d >= 1; d--) {

        if (FrenchTime::dayOfWeek(d, m, y) == 0) {
            return d;
        }
    }
    return 0;
}



uint8_t FrenchTime::dayOfWeek(uint8_t d, uint8_t m, int y)
{
    //Algorithme de Mike Keith
    int weekDay = 0, z = 0;

    if (m >= 3) {
        z = y;
        weekDay = (((23 * m) / 9) + d + 4 + y + (z / 4) - (z / 100) + (z / 400) - 2) % 7;
    } else {
        z = y - 1;
        weekDay = (((23 * m) / 9) + d + 4 + y + (z / 4) - (z / 100) + (z / 400)) % 7;
    }
    return (uint8_t)weekDay;
}


