#include "mbed.h"
#include "servo_ppm.h"

#define JOYSTICK_R_YAxis A0
#define JOYSTICK_R_XAxis A1

#define JOYSTICK_L_YAxis A2
#define JOYSTICK_L_XAxis A3

#define ARM_SWITCH D8
#define MODE_SWITCH A4

#define PPM_PIN A6

#define CAN_TD D2
#define CAN_RD D10

#define JOYSTICK_ID_L 0x0cfdd633
#define JOYSTICK_ID_R 0x0cfdd634

//**FOR SERIAL OUTPUT USING PUTTY                 using 64-bit avaialble from https://www.chiark.greenend.org.uk/~sgtatham/putty/latest.html                                             
Serial pc(SERIAL_TX, SERIAL_RX);  

CAN can(CAN_RD, CAN_TD);

//PPM Output
servo_ppm ppm(PPM_PIN);

//Setup of Analog Inputs
AnalogIn leftXAxis(JOYSTICK_L_XAxis);
AnalogIn leftYAxis(JOYSTICK_L_YAxis);

AnalogIn rightXAxis(JOYSTICK_R_XAxis);
AnalogIn rightYAxis(JOYSTICK_R_YAxis);

AnalogIn modeSwitch(MODE_SWITCH);

//Digital Inputs
DigitalIn armSwitch(ARM_SWITCH);
    
//Function to read the CANbus and decode the data
void readInputs(void) {  

   // pc.printf("LX:%f, LY:%f, RX:%f, RY:%f, ARM:%d , MODE:%f \r\n", leftXAxis.read(), leftYAxis.read(), rightXAxis.read(), rightYAxis.read(), armSwitch.read(), modeSwitch.read());
    
    //left Y axis - Throttle (Pulse 3)
    ppm.setServoPulseDuration_us(3, leftYAxis.read()*1000+1000);
    
    //left X axis - Yaw (Pulse 4)
    ppm.setServoPulseDuration_us(4, leftXAxis.read()*1000+1000);
    
    //right Y Axis - Pitch (Pulse 2)
    ppm.setServoPulseDuration_us(2, rightYAxis.read()*1000+1000);
    
    //right X Axis - Roll (Pulse 1)
    ppm.setServoPulseDuration_us(1, rightXAxis.read()*1000+1000);
    
    //modeSwitch - Pulse 6
    ppm.setServoPulseDuration_us(6, modeSwitch.read()*1000+1000);
    
    //armSwitch - Pulse 5
    ppm.setServoPulseDuration_us(5, armSwitch.read()*1000+1000);
}
/*
void writeCAN() {
    
    
}*/
    
int main() {
    pc.baud(115200);     
    pc.printf("\r\n Starting Pot Joystick to Pixhawk PPM \r\n"); 
                
    //right stick
    ppm.setServoPulseDuration_us(1, 1500);
    ppm.setServoPulseDuration_us(2, 1500);
    //left stick
    ppm.setServoPulseDuration_us(3, 1500);
    ppm.setServoPulseDuration_us(4, 1500);
    //front buttons   
    ppm.setServoPulseDuration_us(5, 1000);
    ppm.setServoPulseDuration_us(6, 1000);
    //top buttons
    ppm.setServoPulseDuration_us(7, 1500);
    ppm.setServoPulseDuration_us(8, 1500);
    
    //start ppm
    ppm.startServoPpmOutput();
    
    armSwitch.mode(PullDown);
    
    can.frequency(250000);

    wait(1.0);

    while(true) {
        readInputs();      //read Joystick CANBus and adjust duty
        
       // writeCAN();
        wait(0.01);
        
        //pc.printf("R: %d, L: %d\r\n", rightDuty, leftDuty);
    }
    
}

                                   

    