#include "mbed.h"

#define CAN_TD D2
#define CAN_RD D10

#define INTERRUPT D8

#define LEFTJOYSTICK true

I2C i2c(I2C_SDA, I2C_SCL);
InterruptIn interrupt(INTERRUPT);
Serial pc(USBTX, USBRX);

CAN can1(CAN_RD, CAN_TD);

const int main_addr = 0x81;
const int alt_addr = 0x83;
const int control = 0x76;

char rawReading[2];

int xAxis = 0;
int yAxis = 0;

int main() {
    
    pc.printf("Starting I2C converter \n");
    //interrupt.fall(&readSensor);
    
    can1.frequency(250000);
    //can1.filter(0x70,0x70,CANExtended); //CANbus filtering to only accept 0x70
    
    CANMessage msg;
    
    msg.format = CANExtended;
    msg.id = 0x71;   //messageID
    msg.len = 8;     //length in bytes
    
    for(int i = 3; i<8; i++) {
            msg.data[i] = 0;
    }
    
    int addr = main_addr;
    
    if(LEFTJOYSTICK) {
        addr = main_addr;
        msg.data[0] = 0;
    }
    else {
        addr = alt_addr;
        msg.data[0] = 1;
    }
        
    while(1) {
        
        i2c.read(addr, rawReading, 2);
        xAxis = (int8_t)(rawReading[0]);
        yAxis = (int8_t)(rawReading[1]);
        msg.data[1] = xAxis;
        msg.data[2] = yAxis;

        //pc.printf("X: %d, Y: %d \n", xAxis, yAxis);
        
        can1.write(msg);
        if(can1.read(msg)) {
            //pc.printf("Recv: %d\n", msg.id);    
        }
        
        //send out CANBus value
        wait(0.02);
    }
}
