/* Copyright (c) Cyntec Inc. All Rights Reserved.
 *
 *
 */

#include "wait_api.h"

#if WIFI_API_DEBUG_LOG
#include "simple_uart.h"
#endif

#include "nrf_gpio.h"
#include "boards.h"
#include "nmi_wlan_if.h"
#include "nmi_wlan.h"//Ryan

#include "spi_flash.h"			//added by Tsungta
#include "wifi_core.h"

extern u8 wifi_event;//Ryan
extern uint8_t nmi_macaddress[6];
extern bool start_routine;


		
void wifi_pin_CFG(void)
{
 //followings are added by Tsungta	
 nrf_gpio_cfg_output(19);	// SWIO	
 nrf_gpio_cfg_output(18);	//WLAN_Wake
 nrf_gpio_cfg_output(8);	//Chip_En
 nrf_gpio_cfg_output(10);	//Reset_n	
 nrf_gpio_pin_set(19);
 nrf_gpio_pin_set(18);	
 nrf_gpio_pin_set(8);
 nrf_gpio_pin_clear(10);		
 wait_ms(1);
 nrf_gpio_pin_set(10);
}

extern u8 hif;//Ryan
uint8_t rx_isr = 0;//Ryan
extern struct nmi_wl_adp_t adp;//Ryan
extern u8 bCfgScanning;//Ryan
extern u8 mac_ready;//Ryan
extern u8 scan_done;//Ryan
u8 MacStatus;//Ryan

void notify_Connect_Status(MAC_STATUS_T connect_status) {
	MacStatus = connect_status;
	if (connect_status == MAC_CONNECTED)
	wifi_event = WIFI_CONNECTED;
	else if (connect_status == MAC_DISCONNECTED)
	wifi_event = WIFI_DISCONNECTED;
	DPRINT(N_ERR, "notify_Connect_Status: %d\r\n", connect_status);
}

void check_rx_int(void)
{
   	if (rx_isr)// == 1)
	{
		rx_isr--;//= 0;
//		adp.core.host_indicate_rx_isr();
		adp.core.host_rx_trans();
	}
}

u8 get_rx_int(void)
{
	return rx_isr+2;
}


extern u8 scanned_match_index;

int wifi_core_start(void)
{

  uint8_t i;
  MacStatus = MAC_DISCONNECTED;//Ryan

if (!start_routine) {
	start_routine = true;

#if WIFI_API_DEBUG_LOG	
  simple_uart_config(RTS_PIN_NUMBER, TX_PIN_NUMBER, CTS_PIN_NUMBER, RX_PIN_NUMBER, HWFC);
#endif
	
	spi_flash_init();
	spi_flash_read_security(0x002000, nmi_macaddress, 6);
}  	


	
	wifi_pin_CFG();
	
  nmc1000_wifi_reset();
  nmc1000_wifi_on();



}

int wait_wifi_event(void)
{
	DPRINT(N_ERR, "wait_wifi_event!!\n");
   while(!wifi_event)
   {
   	if (rx_isr)// == 1)
	{
		rx_isr--;// = 0;
//		adp.core.host_indicate_rx_isr();
		adp.core.host_rx_trans();
		continue;
	}
   	if (hif == 1)
	{
		hif = 0;
		adp.core.host_trans();
		continue;
	}
	//wifi_handle_event
   }	
}

void nmi_os_trace(char *log)
{
#if WIFI_API_DEBUG_LOG	
	simple_uart_putstring((const uint8_t *)log);
#endif	
//	SCI_TraceLow("%s", log);	
}