

#ifndef WIFI_API_H
#define WIFI_API_H

#include <stdbool.h>
#include <stdint.h>

/* @file
* @brief Wi-Fi Connection API for NNN40.
*
*
* @defgroup lib_driver_spi_master Software controlled SPI Master driver
* @{
* @ingroup nrf_drivers
* @brief Software controlled SPI Master driver.
*
* Supported features:
* - Operate two SPI masters independently or in parallel.
* - Transmit and Receive given size of data through SPI.
* - configure each SPI module separately through @ref spi_master_init.
*/

#define SSID_MAX_LENGTH 32
#define SCAN_SSID_MAX_NUM 20

#define ticker_internal 20
#define wait_ms_internal 1

/**
 *  Wi-Fi Init
 */
int wifi_init(void); 
int wifi_apConnect(void);
void wifi_ssid_pw_set(uint8_t* SSID, uint8_t* PW, uint8_t priority);
uint8_t wifi_scan(void);
int wifi_connect(unsigned int timeout_ms);
int wifi_static_ip_set(const char * ip, const char * netmask, const char * gateway);
int wifi_disconnect(void);

int wifi_UDP_server_init(const int port);
int wifi_TCP_server_init(const int port);
int wifi_UDP_client_init(void);
int wifi_TCP_client_init(const char *ipv4_addr, const int port, bool new_socket);
int wifi_send_UDP(char *data, int length, uint8_t cid, const char *ipv4_addr, const int port);
int wifi_send_TCP(char *data, uint8_t cid);




#ifdef __cplusplus
extern "C" {
#endif
void start_socket_routine(void);    
int wifi_receive_UDP_callback(uint8_t *data, uint8_t cid);  
int wifi_receive_TCP_callback(uint8_t *data, uint8_t cid);
void Socket_Close_All(void);
int wifi_ipconfig(unsigned int timeout_ms);
    
#ifdef __cplusplus
}
#endif

#endif
