#ifndef WIFIDEVICE_H_
#define WIFIDEVICE_H_

#include "nmi_wlan_if.h"
#include "nmi_wlan.h"

 /** Interface using WI-FI to connect to Ethernet
 *
 */
class WIFIDevice {
public:

  /** Set WIFI in sleep mode.
  * Disable WIFI and set into sleep mode to conserve energy (no WIFI function is available at this point).
  * \return 0 on success, a negative number on failure
  */
  int sleep(void);

  /** Set the position of embedded RF switch.
  * Set the position of RF switch between WIFI and BLE.
  * \param position set 1 on WIFI to use, set 0 on BLE to use.
  * \return 0 on success, a negative number on failure
  */
  int setSwitch(int position);
  
  /** Get the position of embedded RF switch.
  * Get the current position of RF switch
  * \return get 1 on WIFI to use, get 0 on BLE to use
  */
  int getSwitch(void);
    
//  /** Perform one time WIFI scan.
//  * Scan for available access point on all channels.
//  * \return number of scanned WIFI access point
//  */
//  int oneTimeScan(void);
//
//  /** Get the scanned access point information.
//  * Get the scanned associated access point information table on least oneTimeScan.
//  * \param index query the information of result table in index number [0~19]
//  * \param SSID access point SSID name on query index
//  * \param RSSI access point RSSI (Received Signal Strength Indicator) on query index
//  * \param security access point security type on query index, get 0 on no security, 1 on WEP, 2 on WPA, 3 on WPA2 
//  * \return 0 on success, a negative number on failure when empty
//  */
//  int getScanResult(uint8_t index, uint8_t* SSID, int* RSSI, uint8_t security);
    
  /** Set network connection in priority.
  * Set SSID, password and priority to connect.
  * \param SSID name of access point to connect
  * \param PW password of the given SSID
  * \param priority range from 0 to 2, set 0 for the highest priority
  */
  void setNetwork(char* SSID, char* PW, uint8_t priority);

//  /** Get the status of embedded WIFI chipset.
//  * Get the current status of embedded WIFI chipset
//  * \return get 1 on WIFI to use, get 0 on BLE to use
//  */
//  int getStatus(void);
  
//  /** Set WIFI output power.
//  * Set WIFI output power level 
//  * \param output power level
//  * \return 0 on success, a negative number on failure
//  */
//  int setTxPower(uint8_t powerIndex);
  
};

//#include "EthernetInterface.h"

#endif /* WIFIDEVICE_H_ */