#include "nmi_wlan.h"
#include "nmi_wlan_if.h"

#ifndef __STRC_H__
 #define __STRC_H__
 
typedef struct {
	void *priv;
	void (*scan_callback)(void *, nmi_wl_bss_t *, int, int);
} scan_session_t;

typedef struct {
	int bss_type;
	int connect;
	void *priv;
	u8 sa[6];
	u8 bssid[6];
	void (*join_callback)(void *, nmi_wl_join_rsp_t *);
	void (*disconnect_callback)(void *);
	int dhcp_check;

} join_session_t;

typedef struct wlan_t {

	u32 chipid;
	u32 fw_state;

	/**
	**/
	nmi_wl_platform_t plat;
	nmi_wl_if_t hif;	

	/**
		TX queue
	**/
	que_hdr_t txq_h;

	/**
		RX queue
	**/
	que_hdr_t rxq_h;

	/**
		CFG queue
	**/
	que_hdr_t cfg_w_h;
	que_hdr_t cfg_q_h;
	que_hdr_t cfg_q_rsp_h;
	u32 cfg_id;

	scan_session_t scan_sess;	
	join_session_t join_sess;
	
	int rx_isr;
 	int sleep;
	int fw_en_sleep;

	u8 mac_addr[6];   /* ksong add 2013.5.16 */

	u32 scan_cmd_cnt;	/* ksong 2013-8-9 */
	u32 join_cmd_cnt;	/* ksong 2013-8-9 */
	
#ifdef STATIC_TX_BUFFER
	u8 tx_buffer[600];//[8*1024];
#endif

} nmi_wlan_t;

#endif